package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import zio.aws.sagemaker.model.primitives.{
  RoleArn,
  ProcessingJobArn,
  ProcessingEnvironmentValue,
  Timestamp,
  FailureReason,
  ProcessingEnvironmentKey,
  TrainingJobArn,
  ExitMessage,
  MonitoringScheduleArn,
  ProcessingJobName,
  AutoMLJobArn
}
import scala.jdk.CollectionConverters.*
final case class ProcessingJob(
    processingInputs: Option[
      Iterable[zio.aws.sagemaker.model.ProcessingInput]
    ] = None,
    processingOutputConfig: Option[
      zio.aws.sagemaker.model.ProcessingOutputConfig
    ] = None,
    processingJobName: Option[ProcessingJobName] = None,
    processingResources: Option[zio.aws.sagemaker.model.ProcessingResources] =
      None,
    stoppingCondition: Option[
      zio.aws.sagemaker.model.ProcessingStoppingCondition
    ] = None,
    appSpecification: Option[zio.aws.sagemaker.model.AppSpecification] = None,
    environment: Option[
      Map[ProcessingEnvironmentKey, ProcessingEnvironmentValue]
    ] = None,
    networkConfig: Option[zio.aws.sagemaker.model.NetworkConfig] = None,
    roleArn: Option[RoleArn] = None,
    experimentConfig: Option[zio.aws.sagemaker.model.ExperimentConfig] = None,
    processingJobArn: Option[ProcessingJobArn] = None,
    processingJobStatus: Option[zio.aws.sagemaker.model.ProcessingJobStatus] =
      None,
    exitMessage: Option[ExitMessage] = None,
    failureReason: Option[FailureReason] = None,
    processingEndTime: Option[Timestamp] = None,
    processingStartTime: Option[Timestamp] = None,
    lastModifiedTime: Option[Timestamp] = None,
    creationTime: Option[Timestamp] = None,
    monitoringScheduleArn: Option[MonitoringScheduleArn] = None,
    autoMLJobArn: Option[AutoMLJobArn] = None,
    trainingJobArn: Option[TrainingJobArn] = None,
    tags: Option[Iterable[zio.aws.sagemaker.model.Tag]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.ProcessingJob = {
    import ProcessingJob.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.ProcessingJob
      .builder()
      .optionallyWith(
        processingInputs.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.processingInputs)
      .optionallyWith(
        processingOutputConfig.map(value => value.buildAwsValue())
      )(_.processingOutputConfig)
      .optionallyWith(
        processingJobName.map(value =>
          ProcessingJobName.unwrap(value): java.lang.String
        )
      )(_.processingJobName)
      .optionallyWith(processingResources.map(value => value.buildAwsValue()))(
        _.processingResources
      )
      .optionallyWith(stoppingCondition.map(value => value.buildAwsValue()))(
        _.stoppingCondition
      )
      .optionallyWith(appSpecification.map(value => value.buildAwsValue()))(
        _.appSpecification
      )
      .optionallyWith(
        environment.map(value =>
          value
            .map({ case (key, value) =>
              (ProcessingEnvironmentKey.unwrap(
                key
              ): java.lang.String) -> (ProcessingEnvironmentValue.unwrap(
                value
              ): java.lang.String)
            })
            .asJava
        )
      )(_.environment)
      .optionallyWith(networkConfig.map(value => value.buildAwsValue()))(
        _.networkConfig
      )
      .optionallyWith(
        roleArn.map(value => RoleArn.unwrap(value): java.lang.String)
      )(_.roleArn)
      .optionallyWith(experimentConfig.map(value => value.buildAwsValue()))(
        _.experimentConfig
      )
      .optionallyWith(
        processingJobArn.map(value =>
          ProcessingJobArn.unwrap(value): java.lang.String
        )
      )(_.processingJobArn)
      .optionallyWith(processingJobStatus.map(value => value.unwrap))(
        _.processingJobStatus
      )
      .optionallyWith(
        exitMessage.map(value => ExitMessage.unwrap(value): java.lang.String)
      )(_.exitMessage)
      .optionallyWith(
        failureReason.map(value =>
          FailureReason.unwrap(value): java.lang.String
        )
      )(_.failureReason)
      .optionallyWith(
        processingEndTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.processingEndTime)
      .optionallyWith(
        processingStartTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.processingStartTime)
      .optionallyWith(
        lastModifiedTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.lastModifiedTime)
      .optionallyWith(
        creationTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.creationTime)
      .optionallyWith(
        monitoringScheduleArn.map(value =>
          MonitoringScheduleArn.unwrap(value): java.lang.String
        )
      )(_.monitoringScheduleArn)
      .optionallyWith(
        autoMLJobArn.map(value => AutoMLJobArn.unwrap(value): java.lang.String)
      )(_.autoMLJobArn)
      .optionallyWith(
        trainingJobArn.map(value =>
          TrainingJobArn.unwrap(value): java.lang.String
        )
      )(_.trainingJobArn)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.ProcessingJob.ReadOnly =
    zio.aws.sagemaker.model.ProcessingJob.wrap(buildAwsValue())
}
object ProcessingJob {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.ProcessingJob
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.ProcessingJob =
      zio.aws.sagemaker.model.ProcessingJob(
        processingInputs.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        processingOutputConfig.map(value => value.asEditable),
        processingJobName.map(value => value),
        processingResources.map(value => value.asEditable),
        stoppingCondition.map(value => value.asEditable),
        appSpecification.map(value => value.asEditable),
        environment.map(value => value),
        networkConfig.map(value => value.asEditable),
        roleArn.map(value => value),
        experimentConfig.map(value => value.asEditable),
        processingJobArn.map(value => value),
        processingJobStatus.map(value => value),
        exitMessage.map(value => value),
        failureReason.map(value => value),
        processingEndTime.map(value => value),
        processingStartTime.map(value => value),
        lastModifiedTime.map(value => value),
        creationTime.map(value => value),
        monitoringScheduleArn.map(value => value),
        autoMLJobArn.map(value => value),
        trainingJobArn.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def processingInputs
        : Option[List[zio.aws.sagemaker.model.ProcessingInput.ReadOnly]]
    def processingOutputConfig
        : Option[zio.aws.sagemaker.model.ProcessingOutputConfig.ReadOnly]
    def processingJobName: Option[ProcessingJobName]
    def processingResources
        : Option[zio.aws.sagemaker.model.ProcessingResources.ReadOnly]
    def stoppingCondition
        : Option[zio.aws.sagemaker.model.ProcessingStoppingCondition.ReadOnly]
    def appSpecification
        : Option[zio.aws.sagemaker.model.AppSpecification.ReadOnly]
    def environment
        : Option[Map[ProcessingEnvironmentKey, ProcessingEnvironmentValue]]
    def networkConfig: Option[zio.aws.sagemaker.model.NetworkConfig.ReadOnly]
    def roleArn: Option[RoleArn]
    def experimentConfig
        : Option[zio.aws.sagemaker.model.ExperimentConfig.ReadOnly]
    def processingJobArn: Option[ProcessingJobArn]
    def processingJobStatus: Option[zio.aws.sagemaker.model.ProcessingJobStatus]
    def exitMessage: Option[ExitMessage]
    def failureReason: Option[FailureReason]
    def processingEndTime: Option[Timestamp]
    def processingStartTime: Option[Timestamp]
    def lastModifiedTime: Option[Timestamp]
    def creationTime: Option[Timestamp]
    def monitoringScheduleArn: Option[MonitoringScheduleArn]
    def autoMLJobArn: Option[AutoMLJobArn]
    def trainingJobArn: Option[TrainingJobArn]
    def tags: Option[List[zio.aws.sagemaker.model.Tag.ReadOnly]]
    def getProcessingInputs: ZIO[Any, AwsError, List[
      zio.aws.sagemaker.model.ProcessingInput.ReadOnly
    ]] = AwsError.unwrapOptionField("processingInputs", processingInputs)
    def getProcessingOutputConfig: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.ProcessingOutputConfig.ReadOnly
    ] = AwsError.unwrapOptionField(
      "processingOutputConfig",
      processingOutputConfig
    )
    def getProcessingJobName: ZIO[Any, AwsError, ProcessingJobName] =
      AwsError.unwrapOptionField("processingJobName", processingJobName)
    def getProcessingResources: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.ProcessingResources.ReadOnly
    ] = AwsError.unwrapOptionField("processingResources", processingResources)
    def getStoppingCondition: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.ProcessingStoppingCondition.ReadOnly
    ] = AwsError.unwrapOptionField("stoppingCondition", stoppingCondition)
    def getAppSpecification: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.AppSpecification.ReadOnly
    ] = AwsError.unwrapOptionField("appSpecification", appSpecification)
    def getEnvironment: ZIO[Any, AwsError, Map[
      ProcessingEnvironmentKey,
      ProcessingEnvironmentValue
    ]] = AwsError.unwrapOptionField("environment", environment)
    def getNetworkConfig
        : ZIO[Any, AwsError, zio.aws.sagemaker.model.NetworkConfig.ReadOnly] =
      AwsError.unwrapOptionField("networkConfig", networkConfig)
    def getRoleArn: ZIO[Any, AwsError, RoleArn] =
      AwsError.unwrapOptionField("roleArn", roleArn)
    def getExperimentConfig: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.ExperimentConfig.ReadOnly
    ] = AwsError.unwrapOptionField("experimentConfig", experimentConfig)
    def getProcessingJobArn: ZIO[Any, AwsError, ProcessingJobArn] =
      AwsError.unwrapOptionField("processingJobArn", processingJobArn)
    def getProcessingJobStatus
        : ZIO[Any, AwsError, zio.aws.sagemaker.model.ProcessingJobStatus] =
      AwsError.unwrapOptionField("processingJobStatus", processingJobStatus)
    def getExitMessage: ZIO[Any, AwsError, ExitMessage] =
      AwsError.unwrapOptionField("exitMessage", exitMessage)
    def getFailureReason: ZIO[Any, AwsError, FailureReason] =
      AwsError.unwrapOptionField("failureReason", failureReason)
    def getProcessingEndTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("processingEndTime", processingEndTime)
    def getProcessingStartTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("processingStartTime", processingStartTime)
    def getLastModifiedTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("lastModifiedTime", lastModifiedTime)
    def getCreationTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("creationTime", creationTime)
    def getMonitoringScheduleArn: ZIO[Any, AwsError, MonitoringScheduleArn] =
      AwsError.unwrapOptionField("monitoringScheduleArn", monitoringScheduleArn)
    def getAutoMLJobArn: ZIO[Any, AwsError, AutoMLJobArn] =
      AwsError.unwrapOptionField("autoMLJobArn", autoMLJobArn)
    def getTrainingJobArn: ZIO[Any, AwsError, TrainingJobArn] =
      AwsError.unwrapOptionField("trainingJobArn", trainingJobArn)
    def getTags
        : ZIO[Any, AwsError, List[zio.aws.sagemaker.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.ProcessingJob
  ) extends zio.aws.sagemaker.model.ProcessingJob.ReadOnly {
    override val processingInputs
        : Option[List[zio.aws.sagemaker.model.ProcessingInput.ReadOnly]] = scala
      .Option(impl.processingInputs())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.sagemaker.model.ProcessingInput.wrap(item)
        }.toList
      )
    override val processingOutputConfig
        : Option[zio.aws.sagemaker.model.ProcessingOutputConfig.ReadOnly] =
      scala
        .Option(impl.processingOutputConfig())
        .map(value =>
          zio.aws.sagemaker.model.ProcessingOutputConfig.wrap(value)
        )
    override val processingJobName: Option[ProcessingJobName] = scala
      .Option(impl.processingJobName())
      .map(value => zio.aws.sagemaker.model.primitives.ProcessingJobName(value))
    override val processingResources
        : Option[zio.aws.sagemaker.model.ProcessingResources.ReadOnly] = scala
      .Option(impl.processingResources())
      .map(value => zio.aws.sagemaker.model.ProcessingResources.wrap(value))
    override val stoppingCondition
        : Option[zio.aws.sagemaker.model.ProcessingStoppingCondition.ReadOnly] =
      scala
        .Option(impl.stoppingCondition())
        .map(value =>
          zio.aws.sagemaker.model.ProcessingStoppingCondition.wrap(value)
        )
    override val appSpecification
        : Option[zio.aws.sagemaker.model.AppSpecification.ReadOnly] = scala
      .Option(impl.appSpecification())
      .map(value => zio.aws.sagemaker.model.AppSpecification.wrap(value))
    override val environment
        : Option[Map[ProcessingEnvironmentKey, ProcessingEnvironmentValue]] =
      scala
        .Option(impl.environment())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              zio.aws.sagemaker.model.primitives.ProcessingEnvironmentKey(
                key
              ) -> zio.aws.sagemaker.model.primitives
                .ProcessingEnvironmentValue(value)
            })
            .toMap
        )
    override val networkConfig
        : Option[zio.aws.sagemaker.model.NetworkConfig.ReadOnly] = scala
      .Option(impl.networkConfig())
      .map(value => zio.aws.sagemaker.model.NetworkConfig.wrap(value))
    override val roleArn: Option[RoleArn] = scala
      .Option(impl.roleArn())
      .map(value => zio.aws.sagemaker.model.primitives.RoleArn(value))
    override val experimentConfig
        : Option[zio.aws.sagemaker.model.ExperimentConfig.ReadOnly] = scala
      .Option(impl.experimentConfig())
      .map(value => zio.aws.sagemaker.model.ExperimentConfig.wrap(value))
    override val processingJobArn: Option[ProcessingJobArn] = scala
      .Option(impl.processingJobArn())
      .map(value => zio.aws.sagemaker.model.primitives.ProcessingJobArn(value))
    override val processingJobStatus
        : Option[zio.aws.sagemaker.model.ProcessingJobStatus] = scala
      .Option(impl.processingJobStatus())
      .map(value => zio.aws.sagemaker.model.ProcessingJobStatus.wrap(value))
    override val exitMessage: Option[ExitMessage] = scala
      .Option(impl.exitMessage())
      .map(value => zio.aws.sagemaker.model.primitives.ExitMessage(value))
    override val failureReason: Option[FailureReason] = scala
      .Option(impl.failureReason())
      .map(value => zio.aws.sagemaker.model.primitives.FailureReason(value))
    override val processingEndTime: Option[Timestamp] = scala
      .Option(impl.processingEndTime())
      .map(value => zio.aws.sagemaker.model.primitives.Timestamp(value))
    override val processingStartTime: Option[Timestamp] = scala
      .Option(impl.processingStartTime())
      .map(value => zio.aws.sagemaker.model.primitives.Timestamp(value))
    override val lastModifiedTime: Option[Timestamp] = scala
      .Option(impl.lastModifiedTime())
      .map(value => zio.aws.sagemaker.model.primitives.Timestamp(value))
    override val creationTime: Option[Timestamp] = scala
      .Option(impl.creationTime())
      .map(value => zio.aws.sagemaker.model.primitives.Timestamp(value))
    override val monitoringScheduleArn: Option[MonitoringScheduleArn] = scala
      .Option(impl.monitoringScheduleArn())
      .map(value =>
        zio.aws.sagemaker.model.primitives.MonitoringScheduleArn(value)
      )
    override val autoMLJobArn: Option[AutoMLJobArn] = scala
      .Option(impl.autoMLJobArn())
      .map(value => zio.aws.sagemaker.model.primitives.AutoMLJobArn(value))
    override val trainingJobArn: Option[TrainingJobArn] = scala
      .Option(impl.trainingJobArn())
      .map(value => zio.aws.sagemaker.model.primitives.TrainingJobArn(value))
    override val tags: Option[List[zio.aws.sagemaker.model.Tag.ReadOnly]] =
      scala
        .Option(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.sagemaker.model.Tag.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.ProcessingJob
  ): zio.aws.sagemaker.model.ProcessingJob.ReadOnly = new Wrapper(impl)
}
