package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import zio.aws.sagemaker.model.primitives.{
  RoleArn,
  PipelineDescription,
  Timestamp,
  PipelineArn,
  PipelineName
}
import scala.jdk.CollectionConverters.*
final case class PipelineSummary(
    pipelineArn: Option[PipelineArn] = None,
    pipelineName: Option[PipelineName] = None,
    pipelineDisplayName: Option[PipelineName] = None,
    pipelineDescription: Option[PipelineDescription] = None,
    roleArn: Option[RoleArn] = None,
    creationTime: Option[Timestamp] = None,
    lastModifiedTime: Option[Timestamp] = None,
    lastExecutionTime: Option[Timestamp] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.PipelineSummary = {
    import PipelineSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.PipelineSummary
      .builder()
      .optionallyWith(
        pipelineArn.map(value => PipelineArn.unwrap(value): java.lang.String)
      )(_.pipelineArn)
      .optionallyWith(
        pipelineName.map(value => PipelineName.unwrap(value): java.lang.String)
      )(_.pipelineName)
      .optionallyWith(
        pipelineDisplayName.map(value =>
          PipelineName.unwrap(value): java.lang.String
        )
      )(_.pipelineDisplayName)
      .optionallyWith(
        pipelineDescription.map(value =>
          PipelineDescription.unwrap(value): java.lang.String
        )
      )(_.pipelineDescription)
      .optionallyWith(
        roleArn.map(value => RoleArn.unwrap(value): java.lang.String)
      )(_.roleArn)
      .optionallyWith(
        creationTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.creationTime)
      .optionallyWith(
        lastModifiedTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.lastModifiedTime)
      .optionallyWith(
        lastExecutionTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.lastExecutionTime)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.PipelineSummary.ReadOnly =
    zio.aws.sagemaker.model.PipelineSummary.wrap(buildAwsValue())
}
object PipelineSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.PipelineSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.PipelineSummary =
      zio.aws.sagemaker.model.PipelineSummary(
        pipelineArn.map(value => value),
        pipelineName.map(value => value),
        pipelineDisplayName.map(value => value),
        pipelineDescription.map(value => value),
        roleArn.map(value => value),
        creationTime.map(value => value),
        lastModifiedTime.map(value => value),
        lastExecutionTime.map(value => value)
      )
    def pipelineArn: Option[PipelineArn]
    def pipelineName: Option[PipelineName]
    def pipelineDisplayName: Option[PipelineName]
    def pipelineDescription: Option[PipelineDescription]
    def roleArn: Option[RoleArn]
    def creationTime: Option[Timestamp]
    def lastModifiedTime: Option[Timestamp]
    def lastExecutionTime: Option[Timestamp]
    def getPipelineArn: ZIO[Any, AwsError, PipelineArn] =
      AwsError.unwrapOptionField("pipelineArn", pipelineArn)
    def getPipelineName: ZIO[Any, AwsError, PipelineName] =
      AwsError.unwrapOptionField("pipelineName", pipelineName)
    def getPipelineDisplayName: ZIO[Any, AwsError, PipelineName] =
      AwsError.unwrapOptionField("pipelineDisplayName", pipelineDisplayName)
    def getPipelineDescription: ZIO[Any, AwsError, PipelineDescription] =
      AwsError.unwrapOptionField("pipelineDescription", pipelineDescription)
    def getRoleArn: ZIO[Any, AwsError, RoleArn] =
      AwsError.unwrapOptionField("roleArn", roleArn)
    def getCreationTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("creationTime", creationTime)
    def getLastModifiedTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("lastModifiedTime", lastModifiedTime)
    def getLastExecutionTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("lastExecutionTime", lastExecutionTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.PipelineSummary
  ) extends zio.aws.sagemaker.model.PipelineSummary.ReadOnly {
    override val pipelineArn: Option[PipelineArn] = scala
      .Option(impl.pipelineArn())
      .map(value => zio.aws.sagemaker.model.primitives.PipelineArn(value))
    override val pipelineName: Option[PipelineName] = scala
      .Option(impl.pipelineName())
      .map(value => zio.aws.sagemaker.model.primitives.PipelineName(value))
    override val pipelineDisplayName: Option[PipelineName] = scala
      .Option(impl.pipelineDisplayName())
      .map(value => zio.aws.sagemaker.model.primitives.PipelineName(value))
    override val pipelineDescription: Option[PipelineDescription] = scala
      .Option(impl.pipelineDescription())
      .map(value =>
        zio.aws.sagemaker.model.primitives.PipelineDescription(value)
      )
    override val roleArn: Option[RoleArn] = scala
      .Option(impl.roleArn())
      .map(value => zio.aws.sagemaker.model.primitives.RoleArn(value))
    override val creationTime: Option[Timestamp] = scala
      .Option(impl.creationTime())
      .map(value => zio.aws.sagemaker.model.primitives.Timestamp(value))
    override val lastModifiedTime: Option[Timestamp] = scala
      .Option(impl.lastModifiedTime())
      .map(value => zio.aws.sagemaker.model.primitives.Timestamp(value))
    override val lastExecutionTime: Option[Timestamp] = scala
      .Option(impl.lastExecutionTime())
      .map(value => zio.aws.sagemaker.model.primitives.Timestamp(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.PipelineSummary
  ): zio.aws.sagemaker.model.PipelineSummary.ReadOnly = new Wrapper(impl)
}
