package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import zio.aws.sagemaker.model.primitives.{
  PipelineExecutionName,
  PipelineExecutionFailureReason,
  Timestamp,
  PipelineArn,
  PipelineExecutionArn,
  PipelineExecutionDescription
}
import scala.jdk.CollectionConverters.*
final case class PipelineExecution(
    pipelineArn: Option[PipelineArn] = None,
    pipelineExecutionArn: Option[PipelineExecutionArn] = None,
    pipelineExecutionDisplayName: Option[PipelineExecutionName] = None,
    pipelineExecutionStatus: Option[
      zio.aws.sagemaker.model.PipelineExecutionStatus
    ] = None,
    pipelineExecutionDescription: Option[PipelineExecutionDescription] = None,
    pipelineExperimentConfig: Option[
      zio.aws.sagemaker.model.PipelineExperimentConfig
    ] = None,
    failureReason: Option[PipelineExecutionFailureReason] = None,
    creationTime: Option[Timestamp] = None,
    lastModifiedTime: Option[Timestamp] = None,
    createdBy: Option[zio.aws.sagemaker.model.UserContext] = None,
    lastModifiedBy: Option[zio.aws.sagemaker.model.UserContext] = None,
    parallelismConfiguration: Option[
      zio.aws.sagemaker.model.ParallelismConfiguration
    ] = None,
    pipelineParameters: Option[Iterable[zio.aws.sagemaker.model.Parameter]] =
      None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.PipelineExecution = {
    import PipelineExecution.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.PipelineExecution
      .builder()
      .optionallyWith(
        pipelineArn.map(value => PipelineArn.unwrap(value): java.lang.String)
      )(_.pipelineArn)
      .optionallyWith(
        pipelineExecutionArn.map(value =>
          PipelineExecutionArn.unwrap(value): java.lang.String
        )
      )(_.pipelineExecutionArn)
      .optionallyWith(
        pipelineExecutionDisplayName.map(value =>
          PipelineExecutionName.unwrap(value): java.lang.String
        )
      )(_.pipelineExecutionDisplayName)
      .optionallyWith(pipelineExecutionStatus.map(value => value.unwrap))(
        _.pipelineExecutionStatus
      )
      .optionallyWith(
        pipelineExecutionDescription.map(value =>
          PipelineExecutionDescription.unwrap(value): java.lang.String
        )
      )(_.pipelineExecutionDescription)
      .optionallyWith(
        pipelineExperimentConfig.map(value => value.buildAwsValue())
      )(_.pipelineExperimentConfig)
      .optionallyWith(
        failureReason.map(value =>
          PipelineExecutionFailureReason.unwrap(value): java.lang.String
        )
      )(_.failureReason)
      .optionallyWith(
        creationTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.creationTime)
      .optionallyWith(
        lastModifiedTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.lastModifiedTime)
      .optionallyWith(createdBy.map(value => value.buildAwsValue()))(
        _.createdBy
      )
      .optionallyWith(lastModifiedBy.map(value => value.buildAwsValue()))(
        _.lastModifiedBy
      )
      .optionallyWith(
        parallelismConfiguration.map(value => value.buildAwsValue())
      )(_.parallelismConfiguration)
      .optionallyWith(
        pipelineParameters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.pipelineParameters)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.PipelineExecution.ReadOnly =
    zio.aws.sagemaker.model.PipelineExecution.wrap(buildAwsValue())
}
object PipelineExecution {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.PipelineExecution
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.PipelineExecution =
      zio.aws.sagemaker.model.PipelineExecution(
        pipelineArn.map(value => value),
        pipelineExecutionArn.map(value => value),
        pipelineExecutionDisplayName.map(value => value),
        pipelineExecutionStatus.map(value => value),
        pipelineExecutionDescription.map(value => value),
        pipelineExperimentConfig.map(value => value.asEditable),
        failureReason.map(value => value),
        creationTime.map(value => value),
        lastModifiedTime.map(value => value),
        createdBy.map(value => value.asEditable),
        lastModifiedBy.map(value => value.asEditable),
        parallelismConfiguration.map(value => value.asEditable),
        pipelineParameters.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def pipelineArn: Option[PipelineArn]
    def pipelineExecutionArn: Option[PipelineExecutionArn]
    def pipelineExecutionDisplayName: Option[PipelineExecutionName]
    def pipelineExecutionStatus
        : Option[zio.aws.sagemaker.model.PipelineExecutionStatus]
    def pipelineExecutionDescription: Option[PipelineExecutionDescription]
    def pipelineExperimentConfig
        : Option[zio.aws.sagemaker.model.PipelineExperimentConfig.ReadOnly]
    def failureReason: Option[PipelineExecutionFailureReason]
    def creationTime: Option[Timestamp]
    def lastModifiedTime: Option[Timestamp]
    def createdBy: Option[zio.aws.sagemaker.model.UserContext.ReadOnly]
    def lastModifiedBy: Option[zio.aws.sagemaker.model.UserContext.ReadOnly]
    def parallelismConfiguration
        : Option[zio.aws.sagemaker.model.ParallelismConfiguration.ReadOnly]
    def pipelineParameters
        : Option[List[zio.aws.sagemaker.model.Parameter.ReadOnly]]
    def getPipelineArn: ZIO[Any, AwsError, PipelineArn] =
      AwsError.unwrapOptionField("pipelineArn", pipelineArn)
    def getPipelineExecutionArn: ZIO[Any, AwsError, PipelineExecutionArn] =
      AwsError.unwrapOptionField("pipelineExecutionArn", pipelineExecutionArn)
    def getPipelineExecutionDisplayName
        : ZIO[Any, AwsError, PipelineExecutionName] =
      AwsError.unwrapOptionField(
        "pipelineExecutionDisplayName",
        pipelineExecutionDisplayName
      )
    def getPipelineExecutionStatus
        : ZIO[Any, AwsError, zio.aws.sagemaker.model.PipelineExecutionStatus] =
      AwsError.unwrapOptionField(
        "pipelineExecutionStatus",
        pipelineExecutionStatus
      )
    def getPipelineExecutionDescription
        : ZIO[Any, AwsError, PipelineExecutionDescription] =
      AwsError.unwrapOptionField(
        "pipelineExecutionDescription",
        pipelineExecutionDescription
      )
    def getPipelineExperimentConfig: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.PipelineExperimentConfig.ReadOnly
    ] = AwsError.unwrapOptionField(
      "pipelineExperimentConfig",
      pipelineExperimentConfig
    )
    def getFailureReason: ZIO[Any, AwsError, PipelineExecutionFailureReason] =
      AwsError.unwrapOptionField("failureReason", failureReason)
    def getCreationTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("creationTime", creationTime)
    def getLastModifiedTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("lastModifiedTime", lastModifiedTime)
    def getCreatedBy
        : ZIO[Any, AwsError, zio.aws.sagemaker.model.UserContext.ReadOnly] =
      AwsError.unwrapOptionField("createdBy", createdBy)
    def getLastModifiedBy
        : ZIO[Any, AwsError, zio.aws.sagemaker.model.UserContext.ReadOnly] =
      AwsError.unwrapOptionField("lastModifiedBy", lastModifiedBy)
    def getParallelismConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.ParallelismConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "parallelismConfiguration",
      parallelismConfiguration
    )
    def getPipelineParameters
        : ZIO[Any, AwsError, List[zio.aws.sagemaker.model.Parameter.ReadOnly]] =
      AwsError.unwrapOptionField("pipelineParameters", pipelineParameters)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.PipelineExecution
  ) extends zio.aws.sagemaker.model.PipelineExecution.ReadOnly {
    override val pipelineArn: Option[PipelineArn] = scala
      .Option(impl.pipelineArn())
      .map(value => zio.aws.sagemaker.model.primitives.PipelineArn(value))
    override val pipelineExecutionArn: Option[PipelineExecutionArn] = scala
      .Option(impl.pipelineExecutionArn())
      .map(value =>
        zio.aws.sagemaker.model.primitives.PipelineExecutionArn(value)
      )
    override val pipelineExecutionDisplayName: Option[PipelineExecutionName] =
      scala
        .Option(impl.pipelineExecutionDisplayName())
        .map(value =>
          zio.aws.sagemaker.model.primitives.PipelineExecutionName(value)
        )
    override val pipelineExecutionStatus
        : Option[zio.aws.sagemaker.model.PipelineExecutionStatus] = scala
      .Option(impl.pipelineExecutionStatus())
      .map(value => zio.aws.sagemaker.model.PipelineExecutionStatus.wrap(value))
    override val pipelineExecutionDescription
        : Option[PipelineExecutionDescription] = scala
      .Option(impl.pipelineExecutionDescription())
      .map(value =>
        zio.aws.sagemaker.model.primitives.PipelineExecutionDescription(value)
      )
    override val pipelineExperimentConfig
        : Option[zio.aws.sagemaker.model.PipelineExperimentConfig.ReadOnly] =
      scala
        .Option(impl.pipelineExperimentConfig())
        .map(value =>
          zio.aws.sagemaker.model.PipelineExperimentConfig.wrap(value)
        )
    override val failureReason: Option[PipelineExecutionFailureReason] = scala
      .Option(impl.failureReason())
      .map(value =>
        zio.aws.sagemaker.model.primitives.PipelineExecutionFailureReason(value)
      )
    override val creationTime: Option[Timestamp] = scala
      .Option(impl.creationTime())
      .map(value => zio.aws.sagemaker.model.primitives.Timestamp(value))
    override val lastModifiedTime: Option[Timestamp] = scala
      .Option(impl.lastModifiedTime())
      .map(value => zio.aws.sagemaker.model.primitives.Timestamp(value))
    override val createdBy
        : Option[zio.aws.sagemaker.model.UserContext.ReadOnly] = scala
      .Option(impl.createdBy())
      .map(value => zio.aws.sagemaker.model.UserContext.wrap(value))
    override val lastModifiedBy
        : Option[zio.aws.sagemaker.model.UserContext.ReadOnly] = scala
      .Option(impl.lastModifiedBy())
      .map(value => zio.aws.sagemaker.model.UserContext.wrap(value))
    override val parallelismConfiguration
        : Option[zio.aws.sagemaker.model.ParallelismConfiguration.ReadOnly] =
      scala
        .Option(impl.parallelismConfiguration())
        .map(value =>
          zio.aws.sagemaker.model.ParallelismConfiguration.wrap(value)
        )
    override val pipelineParameters
        : Option[List[zio.aws.sagemaker.model.Parameter.ReadOnly]] = scala
      .Option(impl.pipelineParameters())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.sagemaker.model.Parameter.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.PipelineExecution
  ): zio.aws.sagemaker.model.PipelineExecution.ReadOnly = new Wrapper(impl)
}
