package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class MonitoringNetworkConfig(
    enableInterContainerTrafficEncryption: Option[Boolean] = None,
    enableNetworkIsolation: Option[Boolean] = None,
    vpcConfig: Option[zio.aws.sagemaker.model.VpcConfig] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.MonitoringNetworkConfig = {
    import MonitoringNetworkConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.MonitoringNetworkConfig
      .builder()
      .optionallyWith(
        enableInterContainerTrafficEncryption.map(value =>
          value: java.lang.Boolean
        )
      )(_.enableInterContainerTrafficEncryption)
      .optionallyWith(
        enableNetworkIsolation.map(value => value: java.lang.Boolean)
      )(_.enableNetworkIsolation)
      .optionallyWith(vpcConfig.map(value => value.buildAwsValue()))(
        _.vpcConfig
      )
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.MonitoringNetworkConfig.ReadOnly =
    zio.aws.sagemaker.model.MonitoringNetworkConfig.wrap(buildAwsValue())
}
object MonitoringNetworkConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.MonitoringNetworkConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.MonitoringNetworkConfig =
      zio.aws.sagemaker.model.MonitoringNetworkConfig(
        enableInterContainerTrafficEncryption.map(value => value),
        enableNetworkIsolation.map(value => value),
        vpcConfig.map(value => value.asEditable)
      )
    def enableInterContainerTrafficEncryption: Option[Boolean]
    def enableNetworkIsolation: Option[Boolean]
    def vpcConfig: Option[zio.aws.sagemaker.model.VpcConfig.ReadOnly]
    def getEnableInterContainerTrafficEncryption: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField(
        "enableInterContainerTrafficEncryption",
        enableInterContainerTrafficEncryption
      )
    def getEnableNetworkIsolation: ZIO[Any, AwsError, Boolean] = AwsError
      .unwrapOptionField("enableNetworkIsolation", enableNetworkIsolation)
    def getVpcConfig
        : ZIO[Any, AwsError, zio.aws.sagemaker.model.VpcConfig.ReadOnly] =
      AwsError.unwrapOptionField("vpcConfig", vpcConfig)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.MonitoringNetworkConfig
  ) extends zio.aws.sagemaker.model.MonitoringNetworkConfig.ReadOnly {
    override val enableInterContainerTrafficEncryption: Option[Boolean] = scala
      .Option(impl.enableInterContainerTrafficEncryption())
      .map(value => value: Boolean)
    override val enableNetworkIsolation: Option[Boolean] =
      scala.Option(impl.enableNetworkIsolation()).map(value => value: Boolean)
    override val vpcConfig: Option[zio.aws.sagemaker.model.VpcConfig.ReadOnly] =
      scala
        .Option(impl.vpcConfig())
        .map(value => zio.aws.sagemaker.model.VpcConfig.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.MonitoringNetworkConfig
  ): zio.aws.sagemaker.model.MonitoringNetworkConfig.ReadOnly = new Wrapper(
    impl
  )
}
