package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.sagemaker.model.primitives.String256
import scala.jdk.CollectionConverters.*
final case class ModelStepMetadata(arn: Option[String256] = None) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.ModelStepMetadata = {
    import ModelStepMetadata.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.ModelStepMetadata
      .builder()
      .optionallyWith(
        arn.map(value => String256.unwrap(value): java.lang.String)
      )(_.arn)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.ModelStepMetadata.ReadOnly =
    zio.aws.sagemaker.model.ModelStepMetadata.wrap(buildAwsValue())
}
object ModelStepMetadata {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.ModelStepMetadata
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.ModelStepMetadata =
      zio.aws.sagemaker.model.ModelStepMetadata(arn.map(value => value))
    def arn: Option[String256]
    def getArn: ZIO[Any, AwsError, String256] =
      AwsError.unwrapOptionField("arn", arn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.ModelStepMetadata
  ) extends zio.aws.sagemaker.model.ModelStepMetadata.ReadOnly {
    override val arn: Option[String256] = scala
      .Option(impl.arn())
      .map(value => zio.aws.sagemaker.model.primitives.String256(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.ModelStepMetadata
  ): zio.aws.sagemaker.model.ModelStepMetadata.ReadOnly = new Wrapper(impl)
}
