package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import zio.aws.sagemaker.model.primitives.{Timestamp, MetricName}
import scala.jdk.CollectionConverters.*
final case class MetricData(
    metricName: Option[MetricName] = None,
    value: Option[Float] = None,
    timestamp: Option[Timestamp] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.MetricData = {
    import MetricData.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.MetricData
      .builder()
      .optionallyWith(
        metricName.map(value => MetricName.unwrap(value): java.lang.String)
      )(_.metricName)
      .optionallyWith(value.map(value => value: java.lang.Float))(_.value)
      .optionallyWith(timestamp.map(value => Timestamp.unwrap(value): Instant))(
        _.timestamp
      )
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.MetricData.ReadOnly =
    zio.aws.sagemaker.model.MetricData.wrap(buildAwsValue())
}
object MetricData {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.MetricData
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.MetricData =
      zio.aws.sagemaker.model.MetricData(
        metricName.map(value => value),
        value.map(value => value),
        timestamp.map(value => value)
      )
    def metricName: Option[MetricName]
    def value: Option[Float]
    def timestamp: Option[Timestamp]
    def getMetricName: ZIO[Any, AwsError, MetricName] =
      AwsError.unwrapOptionField("metricName", metricName)
    def getValue: ZIO[Any, AwsError, Float] =
      AwsError.unwrapOptionField("value", value)
    def getTimestamp: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("timestamp", timestamp)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.MetricData
  ) extends zio.aws.sagemaker.model.MetricData.ReadOnly {
    override val metricName: Option[MetricName] = scala
      .Option(impl.metricName())
      .map(value => zio.aws.sagemaker.model.primitives.MetricName(value))
    override val value: Option[Float] =
      scala.Option(impl.value()).map(value => value: Float)
    override val timestamp: Option[Timestamp] = scala
      .Option(impl.timestamp())
      .map(value => zio.aws.sagemaker.model.primitives.Timestamp(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.MetricData
  ): zio.aws.sagemaker.model.MetricData.ReadOnly = new Wrapper(impl)
}
