package zio.aws.sagemaker.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.sagemaker.model.primitives.{
  MaxResults,
  NextToken,
  HyperParameterTuningJobName
}
import scala.jdk.CollectionConverters.*
final case class ListTrainingJobsForHyperParameterTuningJobRequest(
    hyperParameterTuningJobName: HyperParameterTuningJobName,
    nextToken: Option[NextToken] = None,
    maxResults: Option[MaxResults] = None,
    statusEquals: Option[zio.aws.sagemaker.model.TrainingJobStatus] = None,
    sortBy: Option[zio.aws.sagemaker.model.TrainingJobSortByOptions] = None,
    sortOrder: Option[zio.aws.sagemaker.model.SortOrder] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.ListTrainingJobsForHyperParameterTuningJobRequest = {
    import ListTrainingJobsForHyperParameterTuningJobRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.ListTrainingJobsForHyperParameterTuningJobRequest
      .builder()
      .hyperParameterTuningJobName(
        HyperParameterTuningJobName.unwrap(
          hyperParameterTuningJobName
        ): java.lang.String
      )
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(statusEquals.map(value => value.unwrap))(_.statusEquals)
      .optionallyWith(sortBy.map(value => value.unwrap))(_.sortBy)
      .optionallyWith(sortOrder.map(value => value.unwrap))(_.sortOrder)
      .build()
  }
  def asReadOnly
      : zio.aws.sagemaker.model.ListTrainingJobsForHyperParameterTuningJobRequest.ReadOnly =
    zio.aws.sagemaker.model.ListTrainingJobsForHyperParameterTuningJobRequest
      .wrap(buildAwsValue())
}
object ListTrainingJobsForHyperParameterTuningJobRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.ListTrainingJobsForHyperParameterTuningJobRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.sagemaker.model.ListTrainingJobsForHyperParameterTuningJobRequest =
      zio.aws.sagemaker.model.ListTrainingJobsForHyperParameterTuningJobRequest(
        hyperParameterTuningJobName,
        nextToken.map(value => value),
        maxResults.map(value => value),
        statusEquals.map(value => value),
        sortBy.map(value => value),
        sortOrder.map(value => value)
      )
    def hyperParameterTuningJobName: HyperParameterTuningJobName
    def nextToken: Option[NextToken]
    def maxResults: Option[MaxResults]
    def statusEquals: Option[zio.aws.sagemaker.model.TrainingJobStatus]
    def sortBy: Option[zio.aws.sagemaker.model.TrainingJobSortByOptions]
    def sortOrder: Option[zio.aws.sagemaker.model.SortOrder]
    def getHyperParameterTuningJobName
        : ZIO[Any, Nothing, HyperParameterTuningJobName] =
      ZIO.succeed(hyperParameterTuningJobName)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getStatusEquals
        : ZIO[Any, AwsError, zio.aws.sagemaker.model.TrainingJobStatus] =
      AwsError.unwrapOptionField("statusEquals", statusEquals)
    def getSortBy
        : ZIO[Any, AwsError, zio.aws.sagemaker.model.TrainingJobSortByOptions] =
      AwsError.unwrapOptionField("sortBy", sortBy)
    def getSortOrder: ZIO[Any, AwsError, zio.aws.sagemaker.model.SortOrder] =
      AwsError.unwrapOptionField("sortOrder", sortOrder)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.ListTrainingJobsForHyperParameterTuningJobRequest
  ) extends zio.aws.sagemaker.model.ListTrainingJobsForHyperParameterTuningJobRequest.ReadOnly {
    override val hyperParameterTuningJobName: HyperParameterTuningJobName =
      zio.aws.sagemaker.model.primitives
        .HyperParameterTuningJobName(impl.hyperParameterTuningJobName())
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.sagemaker.model.primitives.NextToken(value))
    override val maxResults: Option[MaxResults] = scala
      .Option(impl.maxResults())
      .map(value => zio.aws.sagemaker.model.primitives.MaxResults(value))
    override val statusEquals
        : Option[zio.aws.sagemaker.model.TrainingJobStatus] = scala
      .Option(impl.statusEquals())
      .map(value => zio.aws.sagemaker.model.TrainingJobStatus.wrap(value))
    override val sortBy
        : Option[zio.aws.sagemaker.model.TrainingJobSortByOptions] = scala
      .Option(impl.sortBy())
      .map(value =>
        zio.aws.sagemaker.model.TrainingJobSortByOptions.wrap(value)
      )
    override val sortOrder: Option[zio.aws.sagemaker.model.SortOrder] = scala
      .Option(impl.sortOrder())
      .map(value => zio.aws.sagemaker.model.SortOrder.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.ListTrainingJobsForHyperParameterTuningJobRequest
  ): zio.aws.sagemaker.model.ListTrainingJobsForHyperParameterTuningJobRequest.ReadOnly =
    new Wrapper(impl)
}
