package zio.aws.sagemaker.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.sagemaker.model.primitives.{MaxResults, NextToken, WorkteamName}
import scala.jdk.CollectionConverters.*
final case class ListSubscribedWorkteamsRequest(
    nameContains: Option[WorkteamName] = None,
    nextToken: Option[NextToken] = None,
    maxResults: Option[MaxResults] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.ListSubscribedWorkteamsRequest = {
    import ListSubscribedWorkteamsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.ListSubscribedWorkteamsRequest
      .builder()
      .optionallyWith(
        nameContains.map(value => WorkteamName.unwrap(value): java.lang.String)
      )(_.nameContains)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .build()
  }
  def asReadOnly
      : zio.aws.sagemaker.model.ListSubscribedWorkteamsRequest.ReadOnly =
    zio.aws.sagemaker.model.ListSubscribedWorkteamsRequest.wrap(buildAwsValue())
}
object ListSubscribedWorkteamsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.ListSubscribedWorkteamsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.ListSubscribedWorkteamsRequest =
      zio.aws.sagemaker.model.ListSubscribedWorkteamsRequest(
        nameContains.map(value => value),
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def nameContains: Option[WorkteamName]
    def nextToken: Option[NextToken]
    def maxResults: Option[MaxResults]
    def getNameContains: ZIO[Any, AwsError, WorkteamName] =
      AwsError.unwrapOptionField("nameContains", nameContains)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.ListSubscribedWorkteamsRequest
  ) extends zio.aws.sagemaker.model.ListSubscribedWorkteamsRequest.ReadOnly {
    override val nameContains: Option[WorkteamName] = scala
      .Option(impl.nameContains())
      .map(value => zio.aws.sagemaker.model.primitives.WorkteamName(value))
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.sagemaker.model.primitives.NextToken(value))
    override val maxResults: Option[MaxResults] = scala
      .Option(impl.maxResults())
      .map(value => zio.aws.sagemaker.model.primitives.MaxResults(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.ListSubscribedWorkteamsRequest
  ): zio.aws.sagemaker.model.ListSubscribedWorkteamsRequest.ReadOnly =
    new Wrapper(impl)
}
