package zio.aws.sagemaker.model
import zio.aws.sagemaker.model.primitives.{
  MaxResults,
  NextToken,
  Timestamp,
  PipelineName
}
import java.time.Instant
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class ListPipelineExecutionsRequest(
    pipelineName: PipelineName,
    createdAfter: Option[Timestamp] = None,
    createdBefore: Option[Timestamp] = None,
    sortBy: Option[zio.aws.sagemaker.model.SortPipelineExecutionsBy] = None,
    sortOrder: Option[zio.aws.sagemaker.model.SortOrder] = None,
    nextToken: Option[NextToken] = None,
    maxResults: Option[MaxResults] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.ListPipelineExecutionsRequest = {
    import ListPipelineExecutionsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.ListPipelineExecutionsRequest
      .builder()
      .pipelineName(PipelineName.unwrap(pipelineName): java.lang.String)
      .optionallyWith(
        createdAfter.map(value => Timestamp.unwrap(value): Instant)
      )(_.createdAfter)
      .optionallyWith(
        createdBefore.map(value => Timestamp.unwrap(value): Instant)
      )(_.createdBefore)
      .optionallyWith(sortBy.map(value => value.unwrap))(_.sortBy)
      .optionallyWith(sortOrder.map(value => value.unwrap))(_.sortOrder)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .build()
  }
  def asReadOnly
      : zio.aws.sagemaker.model.ListPipelineExecutionsRequest.ReadOnly =
    zio.aws.sagemaker.model.ListPipelineExecutionsRequest.wrap(buildAwsValue())
}
object ListPipelineExecutionsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.ListPipelineExecutionsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.ListPipelineExecutionsRequest =
      zio.aws.sagemaker.model.ListPipelineExecutionsRequest(
        pipelineName,
        createdAfter.map(value => value),
        createdBefore.map(value => value),
        sortBy.map(value => value),
        sortOrder.map(value => value),
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def pipelineName: PipelineName
    def createdAfter: Option[Timestamp]
    def createdBefore: Option[Timestamp]
    def sortBy: Option[zio.aws.sagemaker.model.SortPipelineExecutionsBy]
    def sortOrder: Option[zio.aws.sagemaker.model.SortOrder]
    def nextToken: Option[NextToken]
    def maxResults: Option[MaxResults]
    def getPipelineName: ZIO[Any, Nothing, PipelineName] =
      ZIO.succeed(pipelineName)
    def getCreatedAfter: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("createdAfter", createdAfter)
    def getCreatedBefore: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("createdBefore", createdBefore)
    def getSortBy
        : ZIO[Any, AwsError, zio.aws.sagemaker.model.SortPipelineExecutionsBy] =
      AwsError.unwrapOptionField("sortBy", sortBy)
    def getSortOrder: ZIO[Any, AwsError, zio.aws.sagemaker.model.SortOrder] =
      AwsError.unwrapOptionField("sortOrder", sortOrder)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.ListPipelineExecutionsRequest
  ) extends zio.aws.sagemaker.model.ListPipelineExecutionsRequest.ReadOnly {
    override val pipelineName: PipelineName =
      zio.aws.sagemaker.model.primitives.PipelineName(impl.pipelineName())
    override val createdAfter: Option[Timestamp] = scala
      .Option(impl.createdAfter())
      .map(value => zio.aws.sagemaker.model.primitives.Timestamp(value))
    override val createdBefore: Option[Timestamp] = scala
      .Option(impl.createdBefore())
      .map(value => zio.aws.sagemaker.model.primitives.Timestamp(value))
    override val sortBy
        : Option[zio.aws.sagemaker.model.SortPipelineExecutionsBy] = scala
      .Option(impl.sortBy())
      .map(value =>
        zio.aws.sagemaker.model.SortPipelineExecutionsBy.wrap(value)
      )
    override val sortOrder: Option[zio.aws.sagemaker.model.SortOrder] = scala
      .Option(impl.sortOrder())
      .map(value => zio.aws.sagemaker.model.SortOrder.wrap(value))
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.sagemaker.model.primitives.NextToken(value))
    override val maxResults: Option[MaxResults] = scala
      .Option(impl.maxResults())
      .map(value => zio.aws.sagemaker.model.primitives.MaxResults(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.ListPipelineExecutionsRequest
  ): zio.aws.sagemaker.model.ListPipelineExecutionsRequest.ReadOnly =
    new Wrapper(impl)
}
