package zio.aws.sagemaker.model
import zio.aws.sagemaker.model.primitives.{
  NextToken,
  MaxResults,
  ImageName,
  Timestamp
}
import java.time.Instant
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class ListImageVersionsRequest(
    creationTimeAfter: Option[Timestamp] = None,
    creationTimeBefore: Option[Timestamp] = None,
    imageName: ImageName,
    lastModifiedTimeAfter: Option[Timestamp] = None,
    lastModifiedTimeBefore: Option[Timestamp] = None,
    maxResults: Option[MaxResults] = None,
    nextToken: Option[NextToken] = None,
    sortBy: Option[zio.aws.sagemaker.model.ImageVersionSortBy] = None,
    sortOrder: Option[zio.aws.sagemaker.model.ImageVersionSortOrder] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.ListImageVersionsRequest = {
    import ListImageVersionsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.ListImageVersionsRequest
      .builder()
      .optionallyWith(
        creationTimeAfter.map(value => Timestamp.unwrap(value): Instant)
      )(_.creationTimeAfter)
      .optionallyWith(
        creationTimeBefore.map(value => Timestamp.unwrap(value): Instant)
      )(_.creationTimeBefore)
      .imageName(ImageName.unwrap(imageName): java.lang.String)
      .optionallyWith(
        lastModifiedTimeAfter.map(value => Timestamp.unwrap(value): Instant)
      )(_.lastModifiedTimeAfter)
      .optionallyWith(
        lastModifiedTimeBefore.map(value => Timestamp.unwrap(value): Instant)
      )(_.lastModifiedTimeBefore)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(sortBy.map(value => value.unwrap))(_.sortBy)
      .optionallyWith(sortOrder.map(value => value.unwrap))(_.sortOrder)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.ListImageVersionsRequest.ReadOnly =
    zio.aws.sagemaker.model.ListImageVersionsRequest.wrap(buildAwsValue())
}
object ListImageVersionsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.ListImageVersionsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.ListImageVersionsRequest =
      zio.aws.sagemaker.model.ListImageVersionsRequest(
        creationTimeAfter.map(value => value),
        creationTimeBefore.map(value => value),
        imageName,
        lastModifiedTimeAfter.map(value => value),
        lastModifiedTimeBefore.map(value => value),
        maxResults.map(value => value),
        nextToken.map(value => value),
        sortBy.map(value => value),
        sortOrder.map(value => value)
      )
    def creationTimeAfter: Option[Timestamp]
    def creationTimeBefore: Option[Timestamp]
    def imageName: ImageName
    def lastModifiedTimeAfter: Option[Timestamp]
    def lastModifiedTimeBefore: Option[Timestamp]
    def maxResults: Option[MaxResults]
    def nextToken: Option[NextToken]
    def sortBy: Option[zio.aws.sagemaker.model.ImageVersionSortBy]
    def sortOrder: Option[zio.aws.sagemaker.model.ImageVersionSortOrder]
    def getCreationTimeAfter: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("creationTimeAfter", creationTimeAfter)
    def getCreationTimeBefore: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("creationTimeBefore", creationTimeBefore)
    def getImageName: ZIO[Any, Nothing, ImageName] = ZIO.succeed(imageName)
    def getLastModifiedTimeAfter: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("lastModifiedTimeAfter", lastModifiedTimeAfter)
    def getLastModifiedTimeBefore: ZIO[Any, AwsError, Timestamp] = AwsError
      .unwrapOptionField("lastModifiedTimeBefore", lastModifiedTimeBefore)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getSortBy
        : ZIO[Any, AwsError, zio.aws.sagemaker.model.ImageVersionSortBy] =
      AwsError.unwrapOptionField("sortBy", sortBy)
    def getSortOrder
        : ZIO[Any, AwsError, zio.aws.sagemaker.model.ImageVersionSortOrder] =
      AwsError.unwrapOptionField("sortOrder", sortOrder)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.ListImageVersionsRequest
  ) extends zio.aws.sagemaker.model.ListImageVersionsRequest.ReadOnly {
    override val creationTimeAfter: Option[Timestamp] = scala
      .Option(impl.creationTimeAfter())
      .map(value => zio.aws.sagemaker.model.primitives.Timestamp(value))
    override val creationTimeBefore: Option[Timestamp] = scala
      .Option(impl.creationTimeBefore())
      .map(value => zio.aws.sagemaker.model.primitives.Timestamp(value))
    override val imageName: ImageName =
      zio.aws.sagemaker.model.primitives.ImageName(impl.imageName())
    override val lastModifiedTimeAfter: Option[Timestamp] = scala
      .Option(impl.lastModifiedTimeAfter())
      .map(value => zio.aws.sagemaker.model.primitives.Timestamp(value))
    override val lastModifiedTimeBefore: Option[Timestamp] = scala
      .Option(impl.lastModifiedTimeBefore())
      .map(value => zio.aws.sagemaker.model.primitives.Timestamp(value))
    override val maxResults: Option[MaxResults] = scala
      .Option(impl.maxResults())
      .map(value => zio.aws.sagemaker.model.primitives.MaxResults(value))
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.sagemaker.model.primitives.NextToken(value))
    override val sortBy: Option[zio.aws.sagemaker.model.ImageVersionSortBy] =
      scala
        .Option(impl.sortBy())
        .map(value => zio.aws.sagemaker.model.ImageVersionSortBy.wrap(value))
    override val sortOrder
        : Option[zio.aws.sagemaker.model.ImageVersionSortOrder] = scala
      .Option(impl.sortOrder())
      .map(value => zio.aws.sagemaker.model.ImageVersionSortOrder.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.ListImageVersionsRequest
  ): zio.aws.sagemaker.model.ListImageVersionsRequest.ReadOnly = new Wrapper(
    impl
  )
}
