package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.sagemaker.model.primitives.NextToken
import scala.jdk.CollectionConverters.*
final case class ListContextsResponse(
    contextSummaries: Option[Iterable[zio.aws.sagemaker.model.ContextSummary]] =
      None,
    nextToken: Option[NextToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.ListContextsResponse = {
    import ListContextsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.ListContextsResponse
      .builder()
      .optionallyWith(
        contextSummaries.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.contextSummaries)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.ListContextsResponse.ReadOnly =
    zio.aws.sagemaker.model.ListContextsResponse.wrap(buildAwsValue())
}
object ListContextsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.ListContextsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.ListContextsResponse =
      zio.aws.sagemaker.model.ListContextsResponse(
        contextSummaries.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def contextSummaries
        : Option[List[zio.aws.sagemaker.model.ContextSummary.ReadOnly]]
    def nextToken: Option[NextToken]
    def getContextSummaries: ZIO[Any, AwsError, List[
      zio.aws.sagemaker.model.ContextSummary.ReadOnly
    ]] = AwsError.unwrapOptionField("contextSummaries", contextSummaries)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.ListContextsResponse
  ) extends zio.aws.sagemaker.model.ListContextsResponse.ReadOnly {
    override val contextSummaries
        : Option[List[zio.aws.sagemaker.model.ContextSummary.ReadOnly]] = scala
      .Option(impl.contextSummaries())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.sagemaker.model.ContextSummary.wrap(item)
        }.toList
      )
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.sagemaker.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.ListContextsResponse
  ): zio.aws.sagemaker.model.ListContextsResponse.ReadOnly = new Wrapper(impl)
}
