package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.sagemaker.model.primitives.NextToken
import scala.jdk.CollectionConverters.*
final case class ListAlgorithmsResponse(
    algorithmSummaryList: Iterable[zio.aws.sagemaker.model.AlgorithmSummary],
    nextToken: Option[NextToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.ListAlgorithmsResponse = {
    import ListAlgorithmsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.ListAlgorithmsResponse
      .builder()
      .algorithmSummaryList(algorithmSummaryList.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.ListAlgorithmsResponse.ReadOnly =
    zio.aws.sagemaker.model.ListAlgorithmsResponse.wrap(buildAwsValue())
}
object ListAlgorithmsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.ListAlgorithmsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.ListAlgorithmsResponse =
      zio.aws.sagemaker.model.ListAlgorithmsResponse(
        algorithmSummaryList.map { item =>
          item.asEditable
        },
        nextToken.map(value => value)
      )
    def algorithmSummaryList
        : List[zio.aws.sagemaker.model.AlgorithmSummary.ReadOnly]
    def nextToken: Option[NextToken]
    def getAlgorithmSummaryList: ZIO[Any, Nothing, List[
      zio.aws.sagemaker.model.AlgorithmSummary.ReadOnly
    ]] = ZIO.succeed(algorithmSummaryList)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.ListAlgorithmsResponse
  ) extends zio.aws.sagemaker.model.ListAlgorithmsResponse.ReadOnly {
    override val algorithmSummaryList
        : List[zio.aws.sagemaker.model.AlgorithmSummary.ReadOnly] = impl
      .algorithmSummaryList()
      .asScala
      .map { item =>
        zio.aws.sagemaker.model.AlgorithmSummary.wrap(item)
      }
      .toList
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.sagemaker.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.ListAlgorithmsResponse
  ): zio.aws.sagemaker.model.ListAlgorithmsResponse.ReadOnly = new Wrapper(impl)
}
