package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.sagemaker.model.primitives.StudioLifecycleConfigArn
import scala.jdk.CollectionConverters.*
final case class JupyterServerAppSettings(
    defaultResourceSpec: Option[zio.aws.sagemaker.model.ResourceSpec] = None,
    lifecycleConfigArns: Option[Iterable[StudioLifecycleConfigArn]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.JupyterServerAppSettings = {
    import JupyterServerAppSettings.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.JupyterServerAppSettings
      .builder()
      .optionallyWith(defaultResourceSpec.map(value => value.buildAwsValue()))(
        _.defaultResourceSpec
      )
      .optionallyWith(
        lifecycleConfigArns.map(value =>
          value.map { item =>
            StudioLifecycleConfigArn.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.lifecycleConfigArns)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.JupyterServerAppSettings.ReadOnly =
    zio.aws.sagemaker.model.JupyterServerAppSettings.wrap(buildAwsValue())
}
object JupyterServerAppSettings {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.JupyterServerAppSettings
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.JupyterServerAppSettings =
      zio.aws.sagemaker.model.JupyterServerAppSettings(
        defaultResourceSpec.map(value => value.asEditable),
        lifecycleConfigArns.map(value => value)
      )
    def defaultResourceSpec
        : Option[zio.aws.sagemaker.model.ResourceSpec.ReadOnly]
    def lifecycleConfigArns: Option[List[StudioLifecycleConfigArn]]
    def getDefaultResourceSpec
        : ZIO[Any, AwsError, zio.aws.sagemaker.model.ResourceSpec.ReadOnly] =
      AwsError.unwrapOptionField("defaultResourceSpec", defaultResourceSpec)
    def getLifecycleConfigArns
        : ZIO[Any, AwsError, List[StudioLifecycleConfigArn]] =
      AwsError.unwrapOptionField("lifecycleConfigArns", lifecycleConfigArns)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.JupyterServerAppSettings
  ) extends zio.aws.sagemaker.model.JupyterServerAppSettings.ReadOnly {
    override val defaultResourceSpec
        : Option[zio.aws.sagemaker.model.ResourceSpec.ReadOnly] = scala
      .Option(impl.defaultResourceSpec())
      .map(value => zio.aws.sagemaker.model.ResourceSpec.wrap(value))
    override val lifecycleConfigArns: Option[List[StudioLifecycleConfigArn]] =
      scala
        .Option(impl.lifecycleConfigArns())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.sagemaker.model.primitives.StudioLifecycleConfigArn(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.JupyterServerAppSettings
  ): zio.aws.sagemaker.model.JupyterServerAppSettings.ReadOnly = new Wrapper(
    impl
  )
}
