package zio.aws.sagemaker.model
import scala.jdk.CollectionConverters.*
sealed trait ImageVersionSortBy {
  def unwrap: software.amazon.awssdk.services.sagemaker.model.ImageVersionSortBy
}
object ImageVersionSortBy {
  def wrap(
      value: software.amazon.awssdk.services.sagemaker.model.ImageVersionSortBy
  ): zio.aws.sagemaker.model.ImageVersionSortBy = value match {
    case software.amazon.awssdk.services.sagemaker.model.ImageVersionSortBy.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.sagemaker.model.ImageVersionSortBy.CREATION_TIME =>
      val r = CREATION_TIME
      r
    case software.amazon.awssdk.services.sagemaker.model.ImageVersionSortBy.LAST_MODIFIED_TIME =>
      val r = LAST_MODIFIED_TIME
      r
    case software.amazon.awssdk.services.sagemaker.model.ImageVersionSortBy.VERSION =>
      val r = VERSION
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.sagemaker.model.ImageVersionSortBy {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.ImageVersionSortBy =
      software.amazon.awssdk.services.sagemaker.model.ImageVersionSortBy.UNKNOWN_TO_SDK_VERSION
  }
  case object CREATION_TIME extends zio.aws.sagemaker.model.ImageVersionSortBy {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.ImageVersionSortBy =
      software.amazon.awssdk.services.sagemaker.model.ImageVersionSortBy.CREATION_TIME
  }
  case object LAST_MODIFIED_TIME
      extends zio.aws.sagemaker.model.ImageVersionSortBy {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.ImageVersionSortBy =
      software.amazon.awssdk.services.sagemaker.model.ImageVersionSortBy.LAST_MODIFIED_TIME
  }
  case object VERSION extends zio.aws.sagemaker.model.ImageVersionSortBy {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.ImageVersionSortBy =
      software.amazon.awssdk.services.sagemaker.model.ImageVersionSortBy.VERSION
  }
}
