package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import zio.aws.sagemaker.model.primitives.{
  ImageDisplayName,
  ImageDescription,
  Timestamp,
  FailureReason,
  ImageArn,
  ImageName
}
import scala.jdk.CollectionConverters.*
final case class Image(
    creationTime: Timestamp,
    description: Option[ImageDescription] = None,
    displayName: Option[ImageDisplayName] = None,
    failureReason: Option[FailureReason] = None,
    imageArn: ImageArn,
    imageName: ImageName,
    imageStatus: zio.aws.sagemaker.model.ImageStatus,
    lastModifiedTime: Timestamp
) {
  def buildAwsValue(): software.amazon.awssdk.services.sagemaker.model.Image = {
    import Image.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.Image
      .builder()
      .creationTime(Timestamp.unwrap(creationTime): Instant)
      .optionallyWith(
        description.map(value =>
          ImageDescription.unwrap(value): java.lang.String
        )
      )(_.description)
      .optionallyWith(
        displayName.map(value =>
          ImageDisplayName.unwrap(value): java.lang.String
        )
      )(_.displayName)
      .optionallyWith(
        failureReason.map(value =>
          FailureReason.unwrap(value): java.lang.String
        )
      )(_.failureReason)
      .imageArn(ImageArn.unwrap(imageArn): java.lang.String)
      .imageName(ImageName.unwrap(imageName): java.lang.String)
      .imageStatus(imageStatus.unwrap)
      .lastModifiedTime(Timestamp.unwrap(lastModifiedTime): Instant)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.Image.ReadOnly =
    zio.aws.sagemaker.model.Image.wrap(buildAwsValue())
}
object Image {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.sagemaker.model.Image] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.Image =
      zio.aws.sagemaker.model.Image(
        creationTime,
        description.map(value => value),
        displayName.map(value => value),
        failureReason.map(value => value),
        imageArn,
        imageName,
        imageStatus,
        lastModifiedTime
      )
    def creationTime: Timestamp
    def description: Option[ImageDescription]
    def displayName: Option[ImageDisplayName]
    def failureReason: Option[FailureReason]
    def imageArn: ImageArn
    def imageName: ImageName
    def imageStatus: zio.aws.sagemaker.model.ImageStatus
    def lastModifiedTime: Timestamp
    def getCreationTime: ZIO[Any, Nothing, Timestamp] =
      ZIO.succeed(creationTime)
    def getDescription: ZIO[Any, AwsError, ImageDescription] =
      AwsError.unwrapOptionField("description", description)
    def getDisplayName: ZIO[Any, AwsError, ImageDisplayName] =
      AwsError.unwrapOptionField("displayName", displayName)
    def getFailureReason: ZIO[Any, AwsError, FailureReason] =
      AwsError.unwrapOptionField("failureReason", failureReason)
    def getImageArn: ZIO[Any, Nothing, ImageArn] = ZIO.succeed(imageArn)
    def getImageName: ZIO[Any, Nothing, ImageName] = ZIO.succeed(imageName)
    def getImageStatus: ZIO[Any, Nothing, zio.aws.sagemaker.model.ImageStatus] =
      ZIO.succeed(imageStatus)
    def getLastModifiedTime: ZIO[Any, Nothing, Timestamp] =
      ZIO.succeed(lastModifiedTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.Image
  ) extends zio.aws.sagemaker.model.Image.ReadOnly {
    override val creationTime: Timestamp =
      zio.aws.sagemaker.model.primitives.Timestamp(impl.creationTime())
    override val description: Option[ImageDescription] = scala
      .Option(impl.description())
      .map(value => zio.aws.sagemaker.model.primitives.ImageDescription(value))
    override val displayName: Option[ImageDisplayName] = scala
      .Option(impl.displayName())
      .map(value => zio.aws.sagemaker.model.primitives.ImageDisplayName(value))
    override val failureReason: Option[FailureReason] = scala
      .Option(impl.failureReason())
      .map(value => zio.aws.sagemaker.model.primitives.FailureReason(value))
    override val imageArn: ImageArn =
      zio.aws.sagemaker.model.primitives.ImageArn(impl.imageArn())
    override val imageName: ImageName =
      zio.aws.sagemaker.model.primitives.ImageName(impl.imageName())
    override val imageStatus: zio.aws.sagemaker.model.ImageStatus =
      zio.aws.sagemaker.model.ImageStatus.wrap(impl.imageStatus())
    override val lastModifiedTime: Timestamp =
      zio.aws.sagemaker.model.primitives.Timestamp(impl.lastModifiedTime())
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.Image
  ): zio.aws.sagemaker.model.Image.ReadOnly = new Wrapper(impl)
}
