package zio.aws.sagemaker.model
import scala.jdk.CollectionConverters.*
sealed trait HyperParameterTuningJobStatus {
  def unwrap: software.amazon.awssdk.services.sagemaker.model.HyperParameterTuningJobStatus
}
object HyperParameterTuningJobStatus {
  def wrap(
      value: software.amazon.awssdk.services.sagemaker.model.HyperParameterTuningJobStatus
  ): zio.aws.sagemaker.model.HyperParameterTuningJobStatus = value match {
    case software.amazon.awssdk.services.sagemaker.model.HyperParameterTuningJobStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.sagemaker.model.HyperParameterTuningJobStatus.COMPLETED =>
      val r = Completed
      r
    case software.amazon.awssdk.services.sagemaker.model.HyperParameterTuningJobStatus.IN_PROGRESS =>
      val r = InProgress
      r
    case software.amazon.awssdk.services.sagemaker.model.HyperParameterTuningJobStatus.FAILED =>
      val r = Failed
      r
    case software.amazon.awssdk.services.sagemaker.model.HyperParameterTuningJobStatus.STOPPED =>
      val r = Stopped
      r
    case software.amazon.awssdk.services.sagemaker.model.HyperParameterTuningJobStatus.STOPPING =>
      val r = Stopping
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.sagemaker.model.HyperParameterTuningJobStatus {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.HyperParameterTuningJobStatus =
      software.amazon.awssdk.services.sagemaker.model.HyperParameterTuningJobStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object Completed
      extends zio.aws.sagemaker.model.HyperParameterTuningJobStatus {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.HyperParameterTuningJobStatus =
      software.amazon.awssdk.services.sagemaker.model.HyperParameterTuningJobStatus.COMPLETED
  }
  case object InProgress
      extends zio.aws.sagemaker.model.HyperParameterTuningJobStatus {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.HyperParameterTuningJobStatus =
      software.amazon.awssdk.services.sagemaker.model.HyperParameterTuningJobStatus.IN_PROGRESS
  }
  case object Failed
      extends zio.aws.sagemaker.model.HyperParameterTuningJobStatus {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.HyperParameterTuningJobStatus =
      software.amazon.awssdk.services.sagemaker.model.HyperParameterTuningJobStatus.FAILED
  }
  case object Stopped
      extends zio.aws.sagemaker.model.HyperParameterTuningJobStatus {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.HyperParameterTuningJobStatus =
      software.amazon.awssdk.services.sagemaker.model.HyperParameterTuningJobStatus.STOPPED
  }
  case object Stopping
      extends zio.aws.sagemaker.model.HyperParameterTuningJobStatus {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.HyperParameterTuningJobStatus =
      software.amazon.awssdk.services.sagemaker.model.HyperParameterTuningJobStatus.STOPPING
  }
}
