package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.sagemaker.model.primitives.{
  RoleArn,
  HyperParameterValue,
  HyperParameterKey,
  HyperParameterTrainingJobDefinitionName
}
import scala.jdk.CollectionConverters.*
final case class HyperParameterTrainingJobDefinition(
    definitionName: Option[HyperParameterTrainingJobDefinitionName] = None,
    tuningObjective: Option[
      zio.aws.sagemaker.model.HyperParameterTuningJobObjective
    ] = None,
    hyperParameterRanges: Option[zio.aws.sagemaker.model.ParameterRanges] =
      None,
    staticHyperParameters: Option[Map[HyperParameterKey, HyperParameterValue]] =
      None,
    algorithmSpecification: zio.aws.sagemaker.model.HyperParameterAlgorithmSpecification,
    roleArn: RoleArn,
    inputDataConfig: Option[Iterable[zio.aws.sagemaker.model.Channel]] = None,
    vpcConfig: Option[zio.aws.sagemaker.model.VpcConfig] = None,
    outputDataConfig: zio.aws.sagemaker.model.OutputDataConfig,
    resourceConfig: zio.aws.sagemaker.model.ResourceConfig,
    stoppingCondition: zio.aws.sagemaker.model.StoppingCondition,
    enableNetworkIsolation: Option[Boolean] = None,
    enableInterContainerTrafficEncryption: Option[Boolean] = None,
    enableManagedSpotTraining: Option[Boolean] = None,
    checkpointConfig: Option[zio.aws.sagemaker.model.CheckpointConfig] = None,
    retryStrategy: Option[zio.aws.sagemaker.model.RetryStrategy] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.HyperParameterTrainingJobDefinition = {
    import HyperParameterTrainingJobDefinition.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.HyperParameterTrainingJobDefinition
      .builder()
      .optionallyWith(
        definitionName.map(value =>
          HyperParameterTrainingJobDefinitionName.unwrap(
            value
          ): java.lang.String
        )
      )(_.definitionName)
      .optionallyWith(tuningObjective.map(value => value.buildAwsValue()))(
        _.tuningObjective
      )
      .optionallyWith(hyperParameterRanges.map(value => value.buildAwsValue()))(
        _.hyperParameterRanges
      )
      .optionallyWith(
        staticHyperParameters.map(value =>
          value
            .map({ case (key, value) =>
              (HyperParameterKey.unwrap(
                key
              ): java.lang.String) -> (HyperParameterValue.unwrap(
                value
              ): java.lang.String)
            })
            .asJava
        )
      )(_.staticHyperParameters)
      .algorithmSpecification(algorithmSpecification.buildAwsValue())
      .roleArn(RoleArn.unwrap(roleArn): java.lang.String)
      .optionallyWith(
        inputDataConfig.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.inputDataConfig)
      .optionallyWith(vpcConfig.map(value => value.buildAwsValue()))(
        _.vpcConfig
      )
      .outputDataConfig(outputDataConfig.buildAwsValue())
      .resourceConfig(resourceConfig.buildAwsValue())
      .stoppingCondition(stoppingCondition.buildAwsValue())
      .optionallyWith(
        enableNetworkIsolation.map(value => value: java.lang.Boolean)
      )(_.enableNetworkIsolation)
      .optionallyWith(
        enableInterContainerTrafficEncryption.map(value =>
          value: java.lang.Boolean
        )
      )(_.enableInterContainerTrafficEncryption)
      .optionallyWith(
        enableManagedSpotTraining.map(value => value: java.lang.Boolean)
      )(_.enableManagedSpotTraining)
      .optionallyWith(checkpointConfig.map(value => value.buildAwsValue()))(
        _.checkpointConfig
      )
      .optionallyWith(retryStrategy.map(value => value.buildAwsValue()))(
        _.retryStrategy
      )
      .build()
  }
  def asReadOnly
      : zio.aws.sagemaker.model.HyperParameterTrainingJobDefinition.ReadOnly =
    zio.aws.sagemaker.model.HyperParameterTrainingJobDefinition
      .wrap(buildAwsValue())
}
object HyperParameterTrainingJobDefinition {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.HyperParameterTrainingJobDefinition
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.sagemaker.model.HyperParameterTrainingJobDefinition =
      zio.aws.sagemaker.model.HyperParameterTrainingJobDefinition(
        definitionName.map(value => value),
        tuningObjective.map(value => value.asEditable),
        hyperParameterRanges.map(value => value.asEditable),
        staticHyperParameters.map(value => value),
        algorithmSpecification.asEditable,
        roleArn,
        inputDataConfig.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        vpcConfig.map(value => value.asEditable),
        outputDataConfig.asEditable,
        resourceConfig.asEditable,
        stoppingCondition.asEditable,
        enableNetworkIsolation.map(value => value),
        enableInterContainerTrafficEncryption.map(value => value),
        enableManagedSpotTraining.map(value => value),
        checkpointConfig.map(value => value.asEditable),
        retryStrategy.map(value => value.asEditable)
      )
    def definitionName: Option[HyperParameterTrainingJobDefinitionName]
    def tuningObjective: Option[
      zio.aws.sagemaker.model.HyperParameterTuningJobObjective.ReadOnly
    ]
    def hyperParameterRanges
        : Option[zio.aws.sagemaker.model.ParameterRanges.ReadOnly]
    def staticHyperParameters
        : Option[Map[HyperParameterKey, HyperParameterValue]]
    def algorithmSpecification
        : zio.aws.sagemaker.model.HyperParameterAlgorithmSpecification.ReadOnly
    def roleArn: RoleArn
    def inputDataConfig: Option[List[zio.aws.sagemaker.model.Channel.ReadOnly]]
    def vpcConfig: Option[zio.aws.sagemaker.model.VpcConfig.ReadOnly]
    def outputDataConfig: zio.aws.sagemaker.model.OutputDataConfig.ReadOnly
    def resourceConfig: zio.aws.sagemaker.model.ResourceConfig.ReadOnly
    def stoppingCondition: zio.aws.sagemaker.model.StoppingCondition.ReadOnly
    def enableNetworkIsolation: Option[Boolean]
    def enableInterContainerTrafficEncryption: Option[Boolean]
    def enableManagedSpotTraining: Option[Boolean]
    def checkpointConfig
        : Option[zio.aws.sagemaker.model.CheckpointConfig.ReadOnly]
    def retryStrategy: Option[zio.aws.sagemaker.model.RetryStrategy.ReadOnly]
    def getDefinitionName
        : ZIO[Any, AwsError, HyperParameterTrainingJobDefinitionName] =
      AwsError.unwrapOptionField("definitionName", definitionName)
    def getTuningObjective: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.HyperParameterTuningJobObjective.ReadOnly
    ] = AwsError.unwrapOptionField("tuningObjective", tuningObjective)
    def getHyperParameterRanges
        : ZIO[Any, AwsError, zio.aws.sagemaker.model.ParameterRanges.ReadOnly] =
      AwsError.unwrapOptionField("hyperParameterRanges", hyperParameterRanges)
    def getStaticHyperParameters
        : ZIO[Any, AwsError, Map[HyperParameterKey, HyperParameterValue]] =
      AwsError.unwrapOptionField("staticHyperParameters", staticHyperParameters)
    def getAlgorithmSpecification: ZIO[
      Any,
      Nothing,
      zio.aws.sagemaker.model.HyperParameterAlgorithmSpecification.ReadOnly
    ] = ZIO.succeed(algorithmSpecification)
    def getRoleArn: ZIO[Any, Nothing, RoleArn] = ZIO.succeed(roleArn)
    def getInputDataConfig
        : ZIO[Any, AwsError, List[zio.aws.sagemaker.model.Channel.ReadOnly]] =
      AwsError.unwrapOptionField("inputDataConfig", inputDataConfig)
    def getVpcConfig
        : ZIO[Any, AwsError, zio.aws.sagemaker.model.VpcConfig.ReadOnly] =
      AwsError.unwrapOptionField("vpcConfig", vpcConfig)
    def getOutputDataConfig
        : ZIO[Any, Nothing, zio.aws.sagemaker.model.OutputDataConfig.ReadOnly] =
      ZIO.succeed(outputDataConfig)
    def getResourceConfig
        : ZIO[Any, Nothing, zio.aws.sagemaker.model.ResourceConfig.ReadOnly] =
      ZIO.succeed(resourceConfig)
    def getStoppingCondition: ZIO[
      Any,
      Nothing,
      zio.aws.sagemaker.model.StoppingCondition.ReadOnly
    ] = ZIO.succeed(stoppingCondition)
    def getEnableNetworkIsolation: ZIO[Any, AwsError, Boolean] = AwsError
      .unwrapOptionField("enableNetworkIsolation", enableNetworkIsolation)
    def getEnableInterContainerTrafficEncryption: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField(
        "enableInterContainerTrafficEncryption",
        enableInterContainerTrafficEncryption
      )
    def getEnableManagedSpotTraining: ZIO[Any, AwsError, Boolean] = AwsError
      .unwrapOptionField("enableManagedSpotTraining", enableManagedSpotTraining)
    def getCheckpointConfig: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.CheckpointConfig.ReadOnly
    ] = AwsError.unwrapOptionField("checkpointConfig", checkpointConfig)
    def getRetryStrategy
        : ZIO[Any, AwsError, zio.aws.sagemaker.model.RetryStrategy.ReadOnly] =
      AwsError.unwrapOptionField("retryStrategy", retryStrategy)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.HyperParameterTrainingJobDefinition
  ) extends zio.aws.sagemaker.model.HyperParameterTrainingJobDefinition.ReadOnly {
    override val definitionName
        : Option[HyperParameterTrainingJobDefinitionName] = scala
      .Option(impl.definitionName())
      .map(value =>
        zio.aws.sagemaker.model.primitives
          .HyperParameterTrainingJobDefinitionName(value)
      )
    override val tuningObjective: Option[
      zio.aws.sagemaker.model.HyperParameterTuningJobObjective.ReadOnly
    ] = scala
      .Option(impl.tuningObjective())
      .map(value =>
        zio.aws.sagemaker.model.HyperParameterTuningJobObjective.wrap(value)
      )
    override val hyperParameterRanges
        : Option[zio.aws.sagemaker.model.ParameterRanges.ReadOnly] = scala
      .Option(impl.hyperParameterRanges())
      .map(value => zio.aws.sagemaker.model.ParameterRanges.wrap(value))
    override val staticHyperParameters
        : Option[Map[HyperParameterKey, HyperParameterValue]] = scala
      .Option(impl.staticHyperParameters())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.sagemaker.model.primitives.HyperParameterKey(
              key
            ) -> zio.aws.sagemaker.model.primitives.HyperParameterValue(value)
          })
          .toMap
      )
    override val algorithmSpecification
        : zio.aws.sagemaker.model.HyperParameterAlgorithmSpecification.ReadOnly =
      zio.aws.sagemaker.model.HyperParameterAlgorithmSpecification
        .wrap(impl.algorithmSpecification())
    override val roleArn: RoleArn =
      zio.aws.sagemaker.model.primitives.RoleArn(impl.roleArn())
    override val inputDataConfig
        : Option[List[zio.aws.sagemaker.model.Channel.ReadOnly]] = scala
      .Option(impl.inputDataConfig())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.sagemaker.model.Channel.wrap(item)
        }.toList
      )
    override val vpcConfig: Option[zio.aws.sagemaker.model.VpcConfig.ReadOnly] =
      scala
        .Option(impl.vpcConfig())
        .map(value => zio.aws.sagemaker.model.VpcConfig.wrap(value))
    override val outputDataConfig
        : zio.aws.sagemaker.model.OutputDataConfig.ReadOnly =
      zio.aws.sagemaker.model.OutputDataConfig.wrap(impl.outputDataConfig())
    override val resourceConfig
        : zio.aws.sagemaker.model.ResourceConfig.ReadOnly =
      zio.aws.sagemaker.model.ResourceConfig.wrap(impl.resourceConfig())
    override val stoppingCondition
        : zio.aws.sagemaker.model.StoppingCondition.ReadOnly =
      zio.aws.sagemaker.model.StoppingCondition.wrap(impl.stoppingCondition())
    override val enableNetworkIsolation: Option[Boolean] =
      scala.Option(impl.enableNetworkIsolation()).map(value => value: Boolean)
    override val enableInterContainerTrafficEncryption: Option[Boolean] = scala
      .Option(impl.enableInterContainerTrafficEncryption())
      .map(value => value: Boolean)
    override val enableManagedSpotTraining: Option[Boolean] = scala
      .Option(impl.enableManagedSpotTraining())
      .map(value => value: Boolean)
    override val checkpointConfig
        : Option[zio.aws.sagemaker.model.CheckpointConfig.ReadOnly] = scala
      .Option(impl.checkpointConfig())
      .map(value => zio.aws.sagemaker.model.CheckpointConfig.wrap(value))
    override val retryStrategy
        : Option[zio.aws.sagemaker.model.RetryStrategy.ReadOnly] = scala
      .Option(impl.retryStrategy())
      .map(value => zio.aws.sagemaker.model.RetryStrategy.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.HyperParameterTrainingJobDefinition
  ): zio.aws.sagemaker.model.HyperParameterTrainingJobDefinition.ReadOnly =
    new Wrapper(impl)
}
