package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.sagemaker.model.primitives.EntityName
import scala.jdk.CollectionConverters.*
final case class GetModelPackageGroupPolicyRequest(
    modelPackageGroupName: EntityName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.GetModelPackageGroupPolicyRequest = {
    import GetModelPackageGroupPolicyRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.GetModelPackageGroupPolicyRequest
      .builder()
      .modelPackageGroupName(
        EntityName.unwrap(modelPackageGroupName): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.sagemaker.model.GetModelPackageGroupPolicyRequest.ReadOnly =
    zio.aws.sagemaker.model.GetModelPackageGroupPolicyRequest
      .wrap(buildAwsValue())
}
object GetModelPackageGroupPolicyRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.GetModelPackageGroupPolicyRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.GetModelPackageGroupPolicyRequest =
      zio.aws.sagemaker.model
        .GetModelPackageGroupPolicyRequest(modelPackageGroupName)
    def modelPackageGroupName: EntityName
    def getModelPackageGroupName: ZIO[Any, Nothing, EntityName] =
      ZIO.succeed(modelPackageGroupName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.GetModelPackageGroupPolicyRequest
  ) extends zio.aws.sagemaker.model.GetModelPackageGroupPolicyRequest.ReadOnly {
    override val modelPackageGroupName: EntityName =
      zio.aws.sagemaker.model.primitives
        .EntityName(impl.modelPackageGroupName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.GetModelPackageGroupPolicyRequest
  ): zio.aws.sagemaker.model.GetModelPackageGroupPolicyRequest.ReadOnly =
    new Wrapper(impl)
}
