package zio.aws.sagemaker.model
import scala.jdk.CollectionConverters.*
sealed trait FileSystemType {
  def unwrap: software.amazon.awssdk.services.sagemaker.model.FileSystemType
}
object FileSystemType {
  def wrap(
      value: software.amazon.awssdk.services.sagemaker.model.FileSystemType
  ): zio.aws.sagemaker.model.FileSystemType = value match {
    case software.amazon.awssdk.services.sagemaker.model.FileSystemType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.sagemaker.model.FileSystemType.EFS =>
      val r = EFS
      r
    case software.amazon.awssdk.services.sagemaker.model.FileSystemType.F_SX_LUSTRE =>
      val r = FSxLustre
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.sagemaker.model.FileSystemType {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.FileSystemType =
      software.amazon.awssdk.services.sagemaker.model.FileSystemType.UNKNOWN_TO_SDK_VERSION
  }
  case object EFS extends zio.aws.sagemaker.model.FileSystemType {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.FileSystemType =
      software.amazon.awssdk.services.sagemaker.model.FileSystemType.EFS
  }
  case object FSxLustre extends zio.aws.sagemaker.model.FileSystemType {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.FileSystemType =
      software.amazon.awssdk.services.sagemaker.model.FileSystemType.F_SX_LUSTRE
  }
}
