package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.sagemaker.model.primitives.String3072
import scala.jdk.CollectionConverters.*
final case class FailStepMetadata(errorMessage: Option[String3072] = None) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.FailStepMetadata = {
    import FailStepMetadata.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.FailStepMetadata
      .builder()
      .optionallyWith(
        errorMessage.map(value => String3072.unwrap(value): java.lang.String)
      )(_.errorMessage)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.FailStepMetadata.ReadOnly =
    zio.aws.sagemaker.model.FailStepMetadata.wrap(buildAwsValue())
}
object FailStepMetadata {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.FailStepMetadata
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.FailStepMetadata =
      zio.aws.sagemaker.model.FailStepMetadata(errorMessage.map(value => value))
    def errorMessage: Option[String3072]
    def getErrorMessage: ZIO[Any, AwsError, String3072] =
      AwsError.unwrapOptionField("errorMessage", errorMessage)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.FailStepMetadata
  ) extends zio.aws.sagemaker.model.FailStepMetadata.ReadOnly {
    override val errorMessage: Option[String3072] = scala
      .Option(impl.errorMessage())
      .map(value => zio.aws.sagemaker.model.primitives.String3072(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.FailStepMetadata
  ): zio.aws.sagemaker.model.FailStepMetadata.ReadOnly = new Wrapper(impl)
}
