package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import zio.aws.sagemaker.model.primitives.{
  CreationTime,
  FailureReason,
  LastModifiedTime,
  DomainId,
  EfsUid,
  UserProfileArn,
  SingleSignOnUserIdentifier,
  UserProfileName,
  String256
}
import scala.jdk.CollectionConverters.*
final case class DescribeUserProfileResponse(
    domainId: Option[DomainId] = None,
    userProfileArn: Option[UserProfileArn] = None,
    userProfileName: Option[UserProfileName] = None,
    homeEfsFileSystemUid: Option[EfsUid] = None,
    status: Option[zio.aws.sagemaker.model.UserProfileStatus] = None,
    lastModifiedTime: Option[LastModifiedTime] = None,
    creationTime: Option[CreationTime] = None,
    failureReason: Option[FailureReason] = None,
    singleSignOnUserIdentifier: Option[SingleSignOnUserIdentifier] = None,
    singleSignOnUserValue: Option[String256] = None,
    userSettings: Option[zio.aws.sagemaker.model.UserSettings] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.DescribeUserProfileResponse = {
    import DescribeUserProfileResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.DescribeUserProfileResponse
      .builder()
      .optionallyWith(
        domainId.map(value => DomainId.unwrap(value): java.lang.String)
      )(_.domainId)
      .optionallyWith(
        userProfileArn.map(value =>
          UserProfileArn.unwrap(value): java.lang.String
        )
      )(_.userProfileArn)
      .optionallyWith(
        userProfileName.map(value =>
          UserProfileName.unwrap(value): java.lang.String
        )
      )(_.userProfileName)
      .optionallyWith(
        homeEfsFileSystemUid.map(value =>
          EfsUid.unwrap(value): java.lang.String
        )
      )(_.homeEfsFileSystemUid)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        lastModifiedTime.map(value => LastModifiedTime.unwrap(value): Instant)
      )(_.lastModifiedTime)
      .optionallyWith(
        creationTime.map(value => CreationTime.unwrap(value): Instant)
      )(_.creationTime)
      .optionallyWith(
        failureReason.map(value =>
          FailureReason.unwrap(value): java.lang.String
        )
      )(_.failureReason)
      .optionallyWith(
        singleSignOnUserIdentifier.map(value =>
          SingleSignOnUserIdentifier.unwrap(value): java.lang.String
        )
      )(_.singleSignOnUserIdentifier)
      .optionallyWith(
        singleSignOnUserValue.map(value =>
          String256.unwrap(value): java.lang.String
        )
      )(_.singleSignOnUserValue)
      .optionallyWith(userSettings.map(value => value.buildAwsValue()))(
        _.userSettings
      )
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.DescribeUserProfileResponse.ReadOnly =
    zio.aws.sagemaker.model.DescribeUserProfileResponse.wrap(buildAwsValue())
}
object DescribeUserProfileResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.DescribeUserProfileResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.DescribeUserProfileResponse =
      zio.aws.sagemaker.model.DescribeUserProfileResponse(
        domainId.map(value => value),
        userProfileArn.map(value => value),
        userProfileName.map(value => value),
        homeEfsFileSystemUid.map(value => value),
        status.map(value => value),
        lastModifiedTime.map(value => value),
        creationTime.map(value => value),
        failureReason.map(value => value),
        singleSignOnUserIdentifier.map(value => value),
        singleSignOnUserValue.map(value => value),
        userSettings.map(value => value.asEditable)
      )
    def domainId: Option[DomainId]
    def userProfileArn: Option[UserProfileArn]
    def userProfileName: Option[UserProfileName]
    def homeEfsFileSystemUid: Option[EfsUid]
    def status: Option[zio.aws.sagemaker.model.UserProfileStatus]
    def lastModifiedTime: Option[LastModifiedTime]
    def creationTime: Option[CreationTime]
    def failureReason: Option[FailureReason]
    def singleSignOnUserIdentifier: Option[SingleSignOnUserIdentifier]
    def singleSignOnUserValue: Option[String256]
    def userSettings: Option[zio.aws.sagemaker.model.UserSettings.ReadOnly]
    def getDomainId: ZIO[Any, AwsError, DomainId] =
      AwsError.unwrapOptionField("domainId", domainId)
    def getUserProfileArn: ZIO[Any, AwsError, UserProfileArn] =
      AwsError.unwrapOptionField("userProfileArn", userProfileArn)
    def getUserProfileName: ZIO[Any, AwsError, UserProfileName] =
      AwsError.unwrapOptionField("userProfileName", userProfileName)
    def getHomeEfsFileSystemUid: ZIO[Any, AwsError, EfsUid] =
      AwsError.unwrapOptionField("homeEfsFileSystemUid", homeEfsFileSystemUid)
    def getStatus
        : ZIO[Any, AwsError, zio.aws.sagemaker.model.UserProfileStatus] =
      AwsError.unwrapOptionField("status", status)
    def getLastModifiedTime: ZIO[Any, AwsError, LastModifiedTime] =
      AwsError.unwrapOptionField("lastModifiedTime", lastModifiedTime)
    def getCreationTime: ZIO[Any, AwsError, CreationTime] =
      AwsError.unwrapOptionField("creationTime", creationTime)
    def getFailureReason: ZIO[Any, AwsError, FailureReason] =
      AwsError.unwrapOptionField("failureReason", failureReason)
    def getSingleSignOnUserIdentifier
        : ZIO[Any, AwsError, SingleSignOnUserIdentifier] =
      AwsError.unwrapOptionField(
        "singleSignOnUserIdentifier",
        singleSignOnUserIdentifier
      )
    def getSingleSignOnUserValue: ZIO[Any, AwsError, String256] =
      AwsError.unwrapOptionField("singleSignOnUserValue", singleSignOnUserValue)
    def getUserSettings
        : ZIO[Any, AwsError, zio.aws.sagemaker.model.UserSettings.ReadOnly] =
      AwsError.unwrapOptionField("userSettings", userSettings)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.DescribeUserProfileResponse
  ) extends zio.aws.sagemaker.model.DescribeUserProfileResponse.ReadOnly {
    override val domainId: Option[DomainId] = scala
      .Option(impl.domainId())
      .map(value => zio.aws.sagemaker.model.primitives.DomainId(value))
    override val userProfileArn: Option[UserProfileArn] = scala
      .Option(impl.userProfileArn())
      .map(value => zio.aws.sagemaker.model.primitives.UserProfileArn(value))
    override val userProfileName: Option[UserProfileName] = scala
      .Option(impl.userProfileName())
      .map(value => zio.aws.sagemaker.model.primitives.UserProfileName(value))
    override val homeEfsFileSystemUid: Option[EfsUid] = scala
      .Option(impl.homeEfsFileSystemUid())
      .map(value => zio.aws.sagemaker.model.primitives.EfsUid(value))
    override val status: Option[zio.aws.sagemaker.model.UserProfileStatus] =
      scala
        .Option(impl.status())
        .map(value => zio.aws.sagemaker.model.UserProfileStatus.wrap(value))
    override val lastModifiedTime: Option[LastModifiedTime] = scala
      .Option(impl.lastModifiedTime())
      .map(value => zio.aws.sagemaker.model.primitives.LastModifiedTime(value))
    override val creationTime: Option[CreationTime] = scala
      .Option(impl.creationTime())
      .map(value => zio.aws.sagemaker.model.primitives.CreationTime(value))
    override val failureReason: Option[FailureReason] = scala
      .Option(impl.failureReason())
      .map(value => zio.aws.sagemaker.model.primitives.FailureReason(value))
    override val singleSignOnUserIdentifier
        : Option[SingleSignOnUserIdentifier] = scala
      .Option(impl.singleSignOnUserIdentifier())
      .map(value =>
        zio.aws.sagemaker.model.primitives.SingleSignOnUserIdentifier(value)
      )
    override val singleSignOnUserValue: Option[String256] = scala
      .Option(impl.singleSignOnUserValue())
      .map(value => zio.aws.sagemaker.model.primitives.String256(value))
    override val userSettings
        : Option[zio.aws.sagemaker.model.UserSettings.ReadOnly] = scala
      .Option(impl.userSettings())
      .map(value => zio.aws.sagemaker.model.UserSettings.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.DescribeUserProfileResponse
  ): zio.aws.sagemaker.model.DescribeUserProfileResponse.ReadOnly = new Wrapper(
    impl
  )
}
