package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.sagemaker.model.primitives.StudioLifecycleConfigName
import scala.jdk.CollectionConverters.*
final case class DescribeStudioLifecycleConfigRequest(
    studioLifecycleConfigName: StudioLifecycleConfigName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.DescribeStudioLifecycleConfigRequest = {
    import DescribeStudioLifecycleConfigRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.DescribeStudioLifecycleConfigRequest
      .builder()
      .studioLifecycleConfigName(
        StudioLifecycleConfigName.unwrap(
          studioLifecycleConfigName
        ): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.sagemaker.model.DescribeStudioLifecycleConfigRequest.ReadOnly =
    zio.aws.sagemaker.model.DescribeStudioLifecycleConfigRequest
      .wrap(buildAwsValue())
}
object DescribeStudioLifecycleConfigRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.DescribeStudioLifecycleConfigRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.sagemaker.model.DescribeStudioLifecycleConfigRequest =
      zio.aws.sagemaker.model
        .DescribeStudioLifecycleConfigRequest(studioLifecycleConfigName)
    def studioLifecycleConfigName: StudioLifecycleConfigName
    def getStudioLifecycleConfigName
        : ZIO[Any, Nothing, StudioLifecycleConfigName] =
      ZIO.succeed(studioLifecycleConfigName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.DescribeStudioLifecycleConfigRequest
  ) extends zio.aws.sagemaker.model.DescribeStudioLifecycleConfigRequest.ReadOnly {
    override val studioLifecycleConfigName: StudioLifecycleConfigName =
      zio.aws.sagemaker.model.primitives
        .StudioLifecycleConfigName(impl.studioLifecycleConfigName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.DescribeStudioLifecycleConfigRequest
  ): zio.aws.sagemaker.model.DescribeStudioLifecycleConfigRequest.ReadOnly =
    new Wrapper(impl)
}
