package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import zio.aws.sagemaker.model.primitives.{
  ModelArn,
  Timestamp,
  RoleArn,
  ModelName
}
import scala.jdk.CollectionConverters.*
final case class DescribeModelResponse(
    modelName: ModelName,
    primaryContainer: Option[zio.aws.sagemaker.model.ContainerDefinition] =
      None,
    containers: Option[Iterable[zio.aws.sagemaker.model.ContainerDefinition]] =
      None,
    inferenceExecutionConfig: Option[
      zio.aws.sagemaker.model.InferenceExecutionConfig
    ] = None,
    executionRoleArn: RoleArn,
    vpcConfig: Option[zio.aws.sagemaker.model.VpcConfig] = None,
    creationTime: Timestamp,
    modelArn: ModelArn,
    enableNetworkIsolation: Option[Boolean] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.DescribeModelResponse = {
    import DescribeModelResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.DescribeModelResponse
      .builder()
      .modelName(ModelName.unwrap(modelName): java.lang.String)
      .optionallyWith(primaryContainer.map(value => value.buildAwsValue()))(
        _.primaryContainer
      )
      .optionallyWith(
        containers.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.containers)
      .optionallyWith(
        inferenceExecutionConfig.map(value => value.buildAwsValue())
      )(_.inferenceExecutionConfig)
      .executionRoleArn(RoleArn.unwrap(executionRoleArn): java.lang.String)
      .optionallyWith(vpcConfig.map(value => value.buildAwsValue()))(
        _.vpcConfig
      )
      .creationTime(Timestamp.unwrap(creationTime): Instant)
      .modelArn(ModelArn.unwrap(modelArn): java.lang.String)
      .optionallyWith(
        enableNetworkIsolation.map(value => value: java.lang.Boolean)
      )(_.enableNetworkIsolation)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.DescribeModelResponse.ReadOnly =
    zio.aws.sagemaker.model.DescribeModelResponse.wrap(buildAwsValue())
}
object DescribeModelResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.DescribeModelResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.DescribeModelResponse =
      zio.aws.sagemaker.model.DescribeModelResponse(
        modelName,
        primaryContainer.map(value => value.asEditable),
        containers.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        inferenceExecutionConfig.map(value => value.asEditable),
        executionRoleArn,
        vpcConfig.map(value => value.asEditable),
        creationTime,
        modelArn,
        enableNetworkIsolation.map(value => value)
      )
    def modelName: ModelName
    def primaryContainer
        : Option[zio.aws.sagemaker.model.ContainerDefinition.ReadOnly]
    def containers
        : Option[List[zio.aws.sagemaker.model.ContainerDefinition.ReadOnly]]
    def inferenceExecutionConfig
        : Option[zio.aws.sagemaker.model.InferenceExecutionConfig.ReadOnly]
    def executionRoleArn: RoleArn
    def vpcConfig: Option[zio.aws.sagemaker.model.VpcConfig.ReadOnly]
    def creationTime: Timestamp
    def modelArn: ModelArn
    def enableNetworkIsolation: Option[Boolean]
    def getModelName: ZIO[Any, Nothing, ModelName] = ZIO.succeed(modelName)
    def getPrimaryContainer: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.ContainerDefinition.ReadOnly
    ] = AwsError.unwrapOptionField("primaryContainer", primaryContainer)
    def getContainers: ZIO[Any, AwsError, List[
      zio.aws.sagemaker.model.ContainerDefinition.ReadOnly
    ]] = AwsError.unwrapOptionField("containers", containers)
    def getInferenceExecutionConfig: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.InferenceExecutionConfig.ReadOnly
    ] = AwsError.unwrapOptionField(
      "inferenceExecutionConfig",
      inferenceExecutionConfig
    )
    def getExecutionRoleArn: ZIO[Any, Nothing, RoleArn] =
      ZIO.succeed(executionRoleArn)
    def getVpcConfig
        : ZIO[Any, AwsError, zio.aws.sagemaker.model.VpcConfig.ReadOnly] =
      AwsError.unwrapOptionField("vpcConfig", vpcConfig)
    def getCreationTime: ZIO[Any, Nothing, Timestamp] =
      ZIO.succeed(creationTime)
    def getModelArn: ZIO[Any, Nothing, ModelArn] = ZIO.succeed(modelArn)
    def getEnableNetworkIsolation: ZIO[Any, AwsError, Boolean] = AwsError
      .unwrapOptionField("enableNetworkIsolation", enableNetworkIsolation)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.DescribeModelResponse
  ) extends zio.aws.sagemaker.model.DescribeModelResponse.ReadOnly {
    override val modelName: ModelName =
      zio.aws.sagemaker.model.primitives.ModelName(impl.modelName())
    override val primaryContainer
        : Option[zio.aws.sagemaker.model.ContainerDefinition.ReadOnly] = scala
      .Option(impl.primaryContainer())
      .map(value => zio.aws.sagemaker.model.ContainerDefinition.wrap(value))
    override val containers
        : Option[List[zio.aws.sagemaker.model.ContainerDefinition.ReadOnly]] =
      scala
        .Option(impl.containers())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.sagemaker.model.ContainerDefinition.wrap(item)
          }.toList
        )
    override val inferenceExecutionConfig
        : Option[zio.aws.sagemaker.model.InferenceExecutionConfig.ReadOnly] =
      scala
        .Option(impl.inferenceExecutionConfig())
        .map(value =>
          zio.aws.sagemaker.model.InferenceExecutionConfig.wrap(value)
        )
    override val executionRoleArn: RoleArn =
      zio.aws.sagemaker.model.primitives.RoleArn(impl.executionRoleArn())
    override val vpcConfig: Option[zio.aws.sagemaker.model.VpcConfig.ReadOnly] =
      scala
        .Option(impl.vpcConfig())
        .map(value => zio.aws.sagemaker.model.VpcConfig.wrap(value))
    override val creationTime: Timestamp =
      zio.aws.sagemaker.model.primitives.Timestamp(impl.creationTime())
    override val modelArn: ModelArn =
      zio.aws.sagemaker.model.primitives.ModelArn(impl.modelArn())
    override val enableNetworkIsolation: Option[Boolean] =
      scala.Option(impl.enableNetworkIsolation()).map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.DescribeModelResponse
  ): zio.aws.sagemaker.model.DescribeModelResponse.ReadOnly = new Wrapper(impl)
}
