package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class DeploymentConfig(
    blueGreenUpdatePolicy: zio.aws.sagemaker.model.BlueGreenUpdatePolicy,
    autoRollbackConfiguration: Option[
      zio.aws.sagemaker.model.AutoRollbackConfig
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.DeploymentConfig = {
    import DeploymentConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.DeploymentConfig
      .builder()
      .blueGreenUpdatePolicy(blueGreenUpdatePolicy.buildAwsValue())
      .optionallyWith(
        autoRollbackConfiguration.map(value => value.buildAwsValue())
      )(_.autoRollbackConfiguration)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.DeploymentConfig.ReadOnly =
    zio.aws.sagemaker.model.DeploymentConfig.wrap(buildAwsValue())
}
object DeploymentConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.DeploymentConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.DeploymentConfig =
      zio.aws.sagemaker.model.DeploymentConfig(
        blueGreenUpdatePolicy.asEditable,
        autoRollbackConfiguration.map(value => value.asEditable)
      )
    def blueGreenUpdatePolicy
        : zio.aws.sagemaker.model.BlueGreenUpdatePolicy.ReadOnly
    def autoRollbackConfiguration
        : Option[zio.aws.sagemaker.model.AutoRollbackConfig.ReadOnly]
    def getBlueGreenUpdatePolicy: ZIO[
      Any,
      Nothing,
      zio.aws.sagemaker.model.BlueGreenUpdatePolicy.ReadOnly
    ] = ZIO.succeed(blueGreenUpdatePolicy)
    def getAutoRollbackConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.AutoRollbackConfig.ReadOnly
    ] = AwsError.unwrapOptionField(
      "autoRollbackConfiguration",
      autoRollbackConfiguration
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.DeploymentConfig
  ) extends zio.aws.sagemaker.model.DeploymentConfig.ReadOnly {
    override val blueGreenUpdatePolicy
        : zio.aws.sagemaker.model.BlueGreenUpdatePolicy.ReadOnly =
      zio.aws.sagemaker.model.BlueGreenUpdatePolicy
        .wrap(impl.blueGreenUpdatePolicy())
    override val autoRollbackConfiguration
        : Option[zio.aws.sagemaker.model.AutoRollbackConfig.ReadOnly] = scala
      .Option(impl.autoRollbackConfiguration())
      .map(value => zio.aws.sagemaker.model.AutoRollbackConfig.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.DeploymentConfig
  ): zio.aws.sagemaker.model.DeploymentConfig.ReadOnly = new Wrapper(impl)
}
