package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import zio.aws.sagemaker.model.primitives.{
  Timestamp,
  StatusDetails,
  ProcessingJobArn,
  RuleConfigurationName
}
import scala.jdk.CollectionConverters.*
final case class DebugRuleEvaluationStatus(
    ruleConfigurationName: Option[RuleConfigurationName] = None,
    ruleEvaluationJobArn: Option[ProcessingJobArn] = None,
    ruleEvaluationStatus: Option[zio.aws.sagemaker.model.RuleEvaluationStatus] =
      None,
    statusDetails: Option[StatusDetails] = None,
    lastModifiedTime: Option[Timestamp] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.DebugRuleEvaluationStatus = {
    import DebugRuleEvaluationStatus.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.DebugRuleEvaluationStatus
      .builder()
      .optionallyWith(
        ruleConfigurationName.map(value =>
          RuleConfigurationName.unwrap(value): java.lang.String
        )
      )(_.ruleConfigurationName)
      .optionallyWith(
        ruleEvaluationJobArn.map(value =>
          ProcessingJobArn.unwrap(value): java.lang.String
        )
      )(_.ruleEvaluationJobArn)
      .optionallyWith(ruleEvaluationStatus.map(value => value.unwrap))(
        _.ruleEvaluationStatus
      )
      .optionallyWith(
        statusDetails.map(value =>
          StatusDetails.unwrap(value): java.lang.String
        )
      )(_.statusDetails)
      .optionallyWith(
        lastModifiedTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.lastModifiedTime)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.DebugRuleEvaluationStatus.ReadOnly =
    zio.aws.sagemaker.model.DebugRuleEvaluationStatus.wrap(buildAwsValue())
}
object DebugRuleEvaluationStatus {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.DebugRuleEvaluationStatus
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.DebugRuleEvaluationStatus =
      zio.aws.sagemaker.model.DebugRuleEvaluationStatus(
        ruleConfigurationName.map(value => value),
        ruleEvaluationJobArn.map(value => value),
        ruleEvaluationStatus.map(value => value),
        statusDetails.map(value => value),
        lastModifiedTime.map(value => value)
      )
    def ruleConfigurationName: Option[RuleConfigurationName]
    def ruleEvaluationJobArn: Option[ProcessingJobArn]
    def ruleEvaluationStatus
        : Option[zio.aws.sagemaker.model.RuleEvaluationStatus]
    def statusDetails: Option[StatusDetails]
    def lastModifiedTime: Option[Timestamp]
    def getRuleConfigurationName: ZIO[Any, AwsError, RuleConfigurationName] =
      AwsError.unwrapOptionField("ruleConfigurationName", ruleConfigurationName)
    def getRuleEvaluationJobArn: ZIO[Any, AwsError, ProcessingJobArn] =
      AwsError.unwrapOptionField("ruleEvaluationJobArn", ruleEvaluationJobArn)
    def getRuleEvaluationStatus
        : ZIO[Any, AwsError, zio.aws.sagemaker.model.RuleEvaluationStatus] =
      AwsError.unwrapOptionField("ruleEvaluationStatus", ruleEvaluationStatus)
    def getStatusDetails: ZIO[Any, AwsError, StatusDetails] =
      AwsError.unwrapOptionField("statusDetails", statusDetails)
    def getLastModifiedTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("lastModifiedTime", lastModifiedTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.DebugRuleEvaluationStatus
  ) extends zio.aws.sagemaker.model.DebugRuleEvaluationStatus.ReadOnly {
    override val ruleConfigurationName: Option[RuleConfigurationName] = scala
      .Option(impl.ruleConfigurationName())
      .map(value =>
        zio.aws.sagemaker.model.primitives.RuleConfigurationName(value)
      )
    override val ruleEvaluationJobArn: Option[ProcessingJobArn] = scala
      .Option(impl.ruleEvaluationJobArn())
      .map(value => zio.aws.sagemaker.model.primitives.ProcessingJobArn(value))
    override val ruleEvaluationStatus
        : Option[zio.aws.sagemaker.model.RuleEvaluationStatus] = scala
      .Option(impl.ruleEvaluationStatus())
      .map(value => zio.aws.sagemaker.model.RuleEvaluationStatus.wrap(value))
    override val statusDetails: Option[StatusDetails] = scala
      .Option(impl.statusDetails())
      .map(value => zio.aws.sagemaker.model.primitives.StatusDetails(value))
    override val lastModifiedTime: Option[Timestamp] = scala
      .Option(impl.lastModifiedTime())
      .map(value => zio.aws.sagemaker.model.primitives.Timestamp(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.DebugRuleEvaluationStatus
  ): zio.aws.sagemaker.model.DebugRuleEvaluationStatus.ReadOnly = new Wrapper(
    impl
  )
}
