package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.sagemaker.model.primitives.TransformJobArn
import scala.jdk.CollectionConverters.*
final case class CreateTransformJobResponse(transformJobArn: TransformJobArn) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.CreateTransformJobResponse = {
    import CreateTransformJobResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.CreateTransformJobResponse
      .builder()
      .transformJobArn(
        TransformJobArn.unwrap(transformJobArn): java.lang.String
      )
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.CreateTransformJobResponse.ReadOnly =
    zio.aws.sagemaker.model.CreateTransformJobResponse.wrap(buildAwsValue())
}
object CreateTransformJobResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.CreateTransformJobResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.CreateTransformJobResponse =
      zio.aws.sagemaker.model.CreateTransformJobResponse(transformJobArn)
    def transformJobArn: TransformJobArn
    def getTransformJobArn: ZIO[Any, Nothing, TransformJobArn] =
      ZIO.succeed(transformJobArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.CreateTransformJobResponse
  ) extends zio.aws.sagemaker.model.CreateTransformJobResponse.ReadOnly {
    override val transformJobArn: TransformJobArn =
      zio.aws.sagemaker.model.primitives.TransformJobArn(impl.transformJobArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.CreateTransformJobResponse
  ): zio.aws.sagemaker.model.CreateTransformJobResponse.ReadOnly = new Wrapper(
    impl
  )
}
