package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.sagemaker.model.primitives.NotebookInstanceUrl
import scala.jdk.CollectionConverters.*
final case class CreatePresignedNotebookInstanceUrlResponse(
    authorizedUrl: Option[NotebookInstanceUrl] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.CreatePresignedNotebookInstanceUrlResponse = {
    import CreatePresignedNotebookInstanceUrlResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.CreatePresignedNotebookInstanceUrlResponse
      .builder()
      .optionallyWith(
        authorizedUrl.map(value =>
          NotebookInstanceUrl.unwrap(value): java.lang.String
        )
      )(_.authorizedUrl)
      .build()
  }
  def asReadOnly
      : zio.aws.sagemaker.model.CreatePresignedNotebookInstanceUrlResponse.ReadOnly =
    zio.aws.sagemaker.model.CreatePresignedNotebookInstanceUrlResponse
      .wrap(buildAwsValue())
}
object CreatePresignedNotebookInstanceUrlResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.CreatePresignedNotebookInstanceUrlResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.sagemaker.model.CreatePresignedNotebookInstanceUrlResponse =
      zio.aws.sagemaker.model.CreatePresignedNotebookInstanceUrlResponse(
        authorizedUrl.map(value => value)
      )
    def authorizedUrl: Option[NotebookInstanceUrl]
    def getAuthorizedUrl: ZIO[Any, AwsError, NotebookInstanceUrl] =
      AwsError.unwrapOptionField("authorizedUrl", authorizedUrl)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.CreatePresignedNotebookInstanceUrlResponse
  ) extends zio.aws.sagemaker.model.CreatePresignedNotebookInstanceUrlResponse.ReadOnly {
    override val authorizedUrl: Option[NotebookInstanceUrl] = scala
      .Option(impl.authorizedUrl())
      .map(value =>
        zio.aws.sagemaker.model.primitives.NotebookInstanceUrl(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.CreatePresignedNotebookInstanceUrlResponse
  ): zio.aws.sagemaker.model.CreatePresignedNotebookInstanceUrlResponse.ReadOnly =
    new Wrapper(impl)
}
