package zio.aws.sagemaker.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.sagemaker.model.primitives.{
  SessionExpirationDurationInSeconds,
  NotebookInstanceName
}
import scala.jdk.CollectionConverters.*
final case class CreatePresignedNotebookInstanceUrlRequest(
    notebookInstanceName: NotebookInstanceName,
    sessionExpirationDurationInSeconds: Option[
      SessionExpirationDurationInSeconds
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.CreatePresignedNotebookInstanceUrlRequest = {
    import CreatePresignedNotebookInstanceUrlRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.CreatePresignedNotebookInstanceUrlRequest
      .builder()
      .notebookInstanceName(
        NotebookInstanceName.unwrap(notebookInstanceName): java.lang.String
      )
      .optionallyWith(
        sessionExpirationDurationInSeconds.map(value =>
          SessionExpirationDurationInSeconds.unwrap(value): Integer
        )
      )(_.sessionExpirationDurationInSeconds)
      .build()
  }
  def asReadOnly
      : zio.aws.sagemaker.model.CreatePresignedNotebookInstanceUrlRequest.ReadOnly =
    zio.aws.sagemaker.model.CreatePresignedNotebookInstanceUrlRequest
      .wrap(buildAwsValue())
}
object CreatePresignedNotebookInstanceUrlRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.CreatePresignedNotebookInstanceUrlRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.sagemaker.model.CreatePresignedNotebookInstanceUrlRequest =
      zio.aws.sagemaker.model.CreatePresignedNotebookInstanceUrlRequest(
        notebookInstanceName,
        sessionExpirationDurationInSeconds.map(value => value)
      )
    def notebookInstanceName: NotebookInstanceName
    def sessionExpirationDurationInSeconds
        : Option[SessionExpirationDurationInSeconds]
    def getNotebookInstanceName: ZIO[Any, Nothing, NotebookInstanceName] =
      ZIO.succeed(notebookInstanceName)
    def getSessionExpirationDurationInSeconds
        : ZIO[Any, AwsError, SessionExpirationDurationInSeconds] =
      AwsError.unwrapOptionField(
        "sessionExpirationDurationInSeconds",
        sessionExpirationDurationInSeconds
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.CreatePresignedNotebookInstanceUrlRequest
  ) extends zio.aws.sagemaker.model.CreatePresignedNotebookInstanceUrlRequest.ReadOnly {
    override val notebookInstanceName: NotebookInstanceName =
      zio.aws.sagemaker.model.primitives
        .NotebookInstanceName(impl.notebookInstanceName())
    override val sessionExpirationDurationInSeconds
        : Option[SessionExpirationDurationInSeconds] = scala
      .Option(impl.sessionExpirationDurationInSeconds())
      .map(value =>
        zio.aws.sagemaker.model.primitives
          .SessionExpirationDurationInSeconds(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.CreatePresignedNotebookInstanceUrlRequest
  ): zio.aws.sagemaker.model.CreatePresignedNotebookInstanceUrlRequest.ReadOnly =
    new Wrapper(impl)
}
