package zio.aws.sagemaker.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.sagemaker.model.primitives.{
  SubnetId,
  RoleArn,
  SecurityGroupId,
  NotebookInstanceVolumeSizeInGB,
  NotebookInstanceName,
  KmsKeyId,
  CodeRepositoryNameOrUrl,
  NotebookInstanceLifecycleConfigName,
  PlatformIdentifier
}
import scala.jdk.CollectionConverters.*
final case class CreateNotebookInstanceRequest(
    notebookInstanceName: NotebookInstanceName,
    instanceType: zio.aws.sagemaker.model.InstanceType,
    subnetId: Option[SubnetId] = None,
    securityGroupIds: Option[Iterable[SecurityGroupId]] = None,
    roleArn: RoleArn,
    kmsKeyId: Option[KmsKeyId] = None,
    tags: Option[Iterable[zio.aws.sagemaker.model.Tag]] = None,
    lifecycleConfigName: Option[NotebookInstanceLifecycleConfigName] = None,
    directInternetAccess: Option[zio.aws.sagemaker.model.DirectInternetAccess] =
      None,
    volumeSizeInGB: Option[NotebookInstanceVolumeSizeInGB] = None,
    acceleratorTypes: Option[
      Iterable[zio.aws.sagemaker.model.NotebookInstanceAcceleratorType]
    ] = None,
    defaultCodeRepository: Option[CodeRepositoryNameOrUrl] = None,
    additionalCodeRepositories: Option[Iterable[CodeRepositoryNameOrUrl]] =
      None,
    rootAccess: Option[zio.aws.sagemaker.model.RootAccess] = None,
    platformIdentifier: Option[PlatformIdentifier] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.CreateNotebookInstanceRequest = {
    import CreateNotebookInstanceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.CreateNotebookInstanceRequest
      .builder()
      .notebookInstanceName(
        NotebookInstanceName.unwrap(notebookInstanceName): java.lang.String
      )
      .instanceType(instanceType.unwrap)
      .optionallyWith(
        subnetId.map(value => SubnetId.unwrap(value): java.lang.String)
      )(_.subnetId)
      .optionallyWith(
        securityGroupIds.map(value =>
          value.map { item =>
            SecurityGroupId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.securityGroupIds)
      .roleArn(RoleArn.unwrap(roleArn): java.lang.String)
      .optionallyWith(
        kmsKeyId.map(value => KmsKeyId.unwrap(value): java.lang.String)
      )(_.kmsKeyId)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .optionallyWith(
        lifecycleConfigName.map(value =>
          NotebookInstanceLifecycleConfigName.unwrap(value): java.lang.String
        )
      )(_.lifecycleConfigName)
      .optionallyWith(directInternetAccess.map(value => value.unwrap))(
        _.directInternetAccess
      )
      .optionallyWith(
        volumeSizeInGB.map(value =>
          NotebookInstanceVolumeSizeInGB.unwrap(value): Integer
        )
      )(_.volumeSizeInGB)
      .optionallyWith(
        acceleratorTypes.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.acceleratorTypesWithStrings)
      .optionallyWith(
        defaultCodeRepository.map(value =>
          CodeRepositoryNameOrUrl.unwrap(value): java.lang.String
        )
      )(_.defaultCodeRepository)
      .optionallyWith(
        additionalCodeRepositories.map(value =>
          value.map { item =>
            CodeRepositoryNameOrUrl.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.additionalCodeRepositories)
      .optionallyWith(rootAccess.map(value => value.unwrap))(_.rootAccess)
      .optionallyWith(
        platformIdentifier.map(value =>
          PlatformIdentifier.unwrap(value): java.lang.String
        )
      )(_.platformIdentifier)
      .build()
  }
  def asReadOnly
      : zio.aws.sagemaker.model.CreateNotebookInstanceRequest.ReadOnly =
    zio.aws.sagemaker.model.CreateNotebookInstanceRequest.wrap(buildAwsValue())
}
object CreateNotebookInstanceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.CreateNotebookInstanceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.CreateNotebookInstanceRequest =
      zio.aws.sagemaker.model.CreateNotebookInstanceRequest(
        notebookInstanceName,
        instanceType,
        subnetId.map(value => value),
        securityGroupIds.map(value => value),
        roleArn,
        kmsKeyId.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        lifecycleConfigName.map(value => value),
        directInternetAccess.map(value => value),
        volumeSizeInGB.map(value => value),
        acceleratorTypes.map(value => value),
        defaultCodeRepository.map(value => value),
        additionalCodeRepositories.map(value => value),
        rootAccess.map(value => value),
        platformIdentifier.map(value => value)
      )
    def notebookInstanceName: NotebookInstanceName
    def instanceType: zio.aws.sagemaker.model.InstanceType
    def subnetId: Option[SubnetId]
    def securityGroupIds: Option[List[SecurityGroupId]]
    def roleArn: RoleArn
    def kmsKeyId: Option[KmsKeyId]
    def tags: Option[List[zio.aws.sagemaker.model.Tag.ReadOnly]]
    def lifecycleConfigName: Option[NotebookInstanceLifecycleConfigName]
    def directInternetAccess
        : Option[zio.aws.sagemaker.model.DirectInternetAccess]
    def volumeSizeInGB: Option[NotebookInstanceVolumeSizeInGB]
    def acceleratorTypes
        : Option[List[zio.aws.sagemaker.model.NotebookInstanceAcceleratorType]]
    def defaultCodeRepository: Option[CodeRepositoryNameOrUrl]
    def additionalCodeRepositories: Option[List[CodeRepositoryNameOrUrl]]
    def rootAccess: Option[zio.aws.sagemaker.model.RootAccess]
    def platformIdentifier: Option[PlatformIdentifier]
    def getNotebookInstanceName: ZIO[Any, Nothing, NotebookInstanceName] =
      ZIO.succeed(notebookInstanceName)
    def getInstanceType
        : ZIO[Any, Nothing, zio.aws.sagemaker.model.InstanceType] =
      ZIO.succeed(instanceType)
    def getSubnetId: ZIO[Any, AwsError, SubnetId] =
      AwsError.unwrapOptionField("subnetId", subnetId)
    def getSecurityGroupIds: ZIO[Any, AwsError, List[SecurityGroupId]] =
      AwsError.unwrapOptionField("securityGroupIds", securityGroupIds)
    def getRoleArn: ZIO[Any, Nothing, RoleArn] = ZIO.succeed(roleArn)
    def getKmsKeyId: ZIO[Any, AwsError, KmsKeyId] =
      AwsError.unwrapOptionField("kmsKeyId", kmsKeyId)
    def getTags
        : ZIO[Any, AwsError, List[zio.aws.sagemaker.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
    def getLifecycleConfigName
        : ZIO[Any, AwsError, NotebookInstanceLifecycleConfigName] =
      AwsError.unwrapOptionField("lifecycleConfigName", lifecycleConfigName)
    def getDirectInternetAccess
        : ZIO[Any, AwsError, zio.aws.sagemaker.model.DirectInternetAccess] =
      AwsError.unwrapOptionField("directInternetAccess", directInternetAccess)
    def getVolumeSizeInGB: ZIO[Any, AwsError, NotebookInstanceVolumeSizeInGB] =
      AwsError.unwrapOptionField("volumeSizeInGB", volumeSizeInGB)
    def getAcceleratorTypes: ZIO[Any, AwsError, List[
      zio.aws.sagemaker.model.NotebookInstanceAcceleratorType
    ]] = AwsError.unwrapOptionField("acceleratorTypes", acceleratorTypes)
    def getDefaultCodeRepository: ZIO[Any, AwsError, CodeRepositoryNameOrUrl] =
      AwsError.unwrapOptionField("defaultCodeRepository", defaultCodeRepository)
    def getAdditionalCodeRepositories
        : ZIO[Any, AwsError, List[CodeRepositoryNameOrUrl]] =
      AwsError.unwrapOptionField(
        "additionalCodeRepositories",
        additionalCodeRepositories
      )
    def getRootAccess: ZIO[Any, AwsError, zio.aws.sagemaker.model.RootAccess] =
      AwsError.unwrapOptionField("rootAccess", rootAccess)
    def getPlatformIdentifier: ZIO[Any, AwsError, PlatformIdentifier] =
      AwsError.unwrapOptionField("platformIdentifier", platformIdentifier)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.CreateNotebookInstanceRequest
  ) extends zio.aws.sagemaker.model.CreateNotebookInstanceRequest.ReadOnly {
    override val notebookInstanceName: NotebookInstanceName =
      zio.aws.sagemaker.model.primitives
        .NotebookInstanceName(impl.notebookInstanceName())
    override val instanceType: zio.aws.sagemaker.model.InstanceType =
      zio.aws.sagemaker.model.InstanceType.wrap(impl.instanceType())
    override val subnetId: Option[SubnetId] = scala
      .Option(impl.subnetId())
      .map(value => zio.aws.sagemaker.model.primitives.SubnetId(value))
    override val securityGroupIds: Option[List[SecurityGroupId]] = scala
      .Option(impl.securityGroupIds())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.sagemaker.model.primitives.SecurityGroupId(item)
        }.toList
      )
    override val roleArn: RoleArn =
      zio.aws.sagemaker.model.primitives.RoleArn(impl.roleArn())
    override val kmsKeyId: Option[KmsKeyId] = scala
      .Option(impl.kmsKeyId())
      .map(value => zio.aws.sagemaker.model.primitives.KmsKeyId(value))
    override val tags: Option[List[zio.aws.sagemaker.model.Tag.ReadOnly]] =
      scala
        .Option(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.sagemaker.model.Tag.wrap(item)
          }.toList
        )
    override val lifecycleConfigName
        : Option[NotebookInstanceLifecycleConfigName] = scala
      .Option(impl.lifecycleConfigName())
      .map(value =>
        zio.aws.sagemaker.model.primitives
          .NotebookInstanceLifecycleConfigName(value)
      )
    override val directInternetAccess
        : Option[zio.aws.sagemaker.model.DirectInternetAccess] = scala
      .Option(impl.directInternetAccess())
      .map(value => zio.aws.sagemaker.model.DirectInternetAccess.wrap(value))
    override val volumeSizeInGB: Option[NotebookInstanceVolumeSizeInGB] = scala
      .Option(impl.volumeSizeInGB())
      .map(value =>
        zio.aws.sagemaker.model.primitives.NotebookInstanceVolumeSizeInGB(value)
      )
    override val acceleratorTypes: Option[
      List[zio.aws.sagemaker.model.NotebookInstanceAcceleratorType]
    ] = scala
      .Option(impl.acceleratorTypes())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.sagemaker.model.NotebookInstanceAcceleratorType.wrap(item)
        }.toList
      )
    override val defaultCodeRepository: Option[CodeRepositoryNameOrUrl] = scala
      .Option(impl.defaultCodeRepository())
      .map(value =>
        zio.aws.sagemaker.model.primitives.CodeRepositoryNameOrUrl(value)
      )
    override val additionalCodeRepositories
        : Option[List[CodeRepositoryNameOrUrl]] = scala
      .Option(impl.additionalCodeRepositories())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.sagemaker.model.primitives.CodeRepositoryNameOrUrl(item)
        }.toList
      )
    override val rootAccess: Option[zio.aws.sagemaker.model.RootAccess] = scala
      .Option(impl.rootAccess())
      .map(value => zio.aws.sagemaker.model.RootAccess.wrap(value))
    override val platformIdentifier: Option[PlatformIdentifier] = scala
      .Option(impl.platformIdentifier())
      .map(value =>
        zio.aws.sagemaker.model.primitives.PlatformIdentifier(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.CreateNotebookInstanceRequest
  ): zio.aws.sagemaker.model.CreateNotebookInstanceRequest.ReadOnly =
    new Wrapper(impl)
}
