package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.sagemaker.model.primitives.{
  ExperimentDescription,
  ExperimentEntityName
}
import scala.jdk.CollectionConverters.*
final case class CreateExperimentRequest(
    experimentName: ExperimentEntityName,
    displayName: Option[ExperimentEntityName] = None,
    description: Option[ExperimentDescription] = None,
    tags: Option[Iterable[zio.aws.sagemaker.model.Tag]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.CreateExperimentRequest = {
    import CreateExperimentRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.CreateExperimentRequest
      .builder()
      .experimentName(
        ExperimentEntityName.unwrap(experimentName): java.lang.String
      )
      .optionallyWith(
        displayName.map(value =>
          ExperimentEntityName.unwrap(value): java.lang.String
        )
      )(_.displayName)
      .optionallyWith(
        description.map(value =>
          ExperimentDescription.unwrap(value): java.lang.String
        )
      )(_.description)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.CreateExperimentRequest.ReadOnly =
    zio.aws.sagemaker.model.CreateExperimentRequest.wrap(buildAwsValue())
}
object CreateExperimentRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.CreateExperimentRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.CreateExperimentRequest =
      zio.aws.sagemaker.model.CreateExperimentRequest(
        experimentName,
        displayName.map(value => value),
        description.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def experimentName: ExperimentEntityName
    def displayName: Option[ExperimentEntityName]
    def description: Option[ExperimentDescription]
    def tags: Option[List[zio.aws.sagemaker.model.Tag.ReadOnly]]
    def getExperimentName: ZIO[Any, Nothing, ExperimentEntityName] =
      ZIO.succeed(experimentName)
    def getDisplayName: ZIO[Any, AwsError, ExperimentEntityName] =
      AwsError.unwrapOptionField("displayName", displayName)
    def getDescription: ZIO[Any, AwsError, ExperimentDescription] =
      AwsError.unwrapOptionField("description", description)
    def getTags
        : ZIO[Any, AwsError, List[zio.aws.sagemaker.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.CreateExperimentRequest
  ) extends zio.aws.sagemaker.model.CreateExperimentRequest.ReadOnly {
    override val experimentName: ExperimentEntityName =
      zio.aws.sagemaker.model.primitives
        .ExperimentEntityName(impl.experimentName())
    override val displayName: Option[ExperimentEntityName] = scala
      .Option(impl.displayName())
      .map(value =>
        zio.aws.sagemaker.model.primitives.ExperimentEntityName(value)
      )
    override val description: Option[ExperimentDescription] = scala
      .Option(impl.description())
      .map(value =>
        zio.aws.sagemaker.model.primitives.ExperimentDescription(value)
      )
    override val tags: Option[List[zio.aws.sagemaker.model.Tag.ReadOnly]] =
      scala
        .Option(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.sagemaker.model.Tag.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.CreateExperimentRequest
  ): zio.aws.sagemaker.model.CreateExperimentRequest.ReadOnly = new Wrapper(
    impl
  )
}
