package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import zio.aws.sagemaker.model.primitives.{
  CreationTime,
  Timestamp,
  CompilationJobArn,
  LastModifiedTime,
  EntityName
}
import scala.jdk.CollectionConverters.*
final case class CompilationJobSummary(
    compilationJobName: EntityName,
    compilationJobArn: CompilationJobArn,
    creationTime: CreationTime,
    compilationStartTime: Option[Timestamp] = None,
    compilationEndTime: Option[Timestamp] = None,
    compilationTargetDevice: Option[zio.aws.sagemaker.model.TargetDevice] =
      None,
    compilationTargetPlatformOs: Option[
      zio.aws.sagemaker.model.TargetPlatformOs
    ] = None,
    compilationTargetPlatformArch: Option[
      zio.aws.sagemaker.model.TargetPlatformArch
    ] = None,
    compilationTargetPlatformAccelerator: Option[
      zio.aws.sagemaker.model.TargetPlatformAccelerator
    ] = None,
    lastModifiedTime: Option[LastModifiedTime] = None,
    compilationJobStatus: zio.aws.sagemaker.model.CompilationJobStatus
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.CompilationJobSummary = {
    import CompilationJobSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.CompilationJobSummary
      .builder()
      .compilationJobName(
        EntityName.unwrap(compilationJobName): java.lang.String
      )
      .compilationJobArn(
        CompilationJobArn.unwrap(compilationJobArn): java.lang.String
      )
      .creationTime(CreationTime.unwrap(creationTime): Instant)
      .optionallyWith(
        compilationStartTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.compilationStartTime)
      .optionallyWith(
        compilationEndTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.compilationEndTime)
      .optionallyWith(compilationTargetDevice.map(value => value.unwrap))(
        _.compilationTargetDevice
      )
      .optionallyWith(compilationTargetPlatformOs.map(value => value.unwrap))(
        _.compilationTargetPlatformOs
      )
      .optionallyWith(compilationTargetPlatformArch.map(value => value.unwrap))(
        _.compilationTargetPlatformArch
      )
      .optionallyWith(
        compilationTargetPlatformAccelerator.map(value => value.unwrap)
      )(_.compilationTargetPlatformAccelerator)
      .optionallyWith(
        lastModifiedTime.map(value => LastModifiedTime.unwrap(value): Instant)
      )(_.lastModifiedTime)
      .compilationJobStatus(compilationJobStatus.unwrap)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.CompilationJobSummary.ReadOnly =
    zio.aws.sagemaker.model.CompilationJobSummary.wrap(buildAwsValue())
}
object CompilationJobSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.CompilationJobSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.CompilationJobSummary =
      zio.aws.sagemaker.model.CompilationJobSummary(
        compilationJobName,
        compilationJobArn,
        creationTime,
        compilationStartTime.map(value => value),
        compilationEndTime.map(value => value),
        compilationTargetDevice.map(value => value),
        compilationTargetPlatformOs.map(value => value),
        compilationTargetPlatformArch.map(value => value),
        compilationTargetPlatformAccelerator.map(value => value),
        lastModifiedTime.map(value => value),
        compilationJobStatus
      )
    def compilationJobName: EntityName
    def compilationJobArn: CompilationJobArn
    def creationTime: CreationTime
    def compilationStartTime: Option[Timestamp]
    def compilationEndTime: Option[Timestamp]
    def compilationTargetDevice: Option[zio.aws.sagemaker.model.TargetDevice]
    def compilationTargetPlatformOs
        : Option[zio.aws.sagemaker.model.TargetPlatformOs]
    def compilationTargetPlatformArch
        : Option[zio.aws.sagemaker.model.TargetPlatformArch]
    def compilationTargetPlatformAccelerator
        : Option[zio.aws.sagemaker.model.TargetPlatformAccelerator]
    def lastModifiedTime: Option[LastModifiedTime]
    def compilationJobStatus: zio.aws.sagemaker.model.CompilationJobStatus
    def getCompilationJobName: ZIO[Any, Nothing, EntityName] =
      ZIO.succeed(compilationJobName)
    def getCompilationJobArn: ZIO[Any, Nothing, CompilationJobArn] =
      ZIO.succeed(compilationJobArn)
    def getCreationTime: ZIO[Any, Nothing, CreationTime] =
      ZIO.succeed(creationTime)
    def getCompilationStartTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("compilationStartTime", compilationStartTime)
    def getCompilationEndTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("compilationEndTime", compilationEndTime)
    def getCompilationTargetDevice
        : ZIO[Any, AwsError, zio.aws.sagemaker.model.TargetDevice] = AwsError
      .unwrapOptionField("compilationTargetDevice", compilationTargetDevice)
    def getCompilationTargetPlatformOs
        : ZIO[Any, AwsError, zio.aws.sagemaker.model.TargetPlatformOs] =
      AwsError.unwrapOptionField(
        "compilationTargetPlatformOs",
        compilationTargetPlatformOs
      )
    def getCompilationTargetPlatformArch
        : ZIO[Any, AwsError, zio.aws.sagemaker.model.TargetPlatformArch] =
      AwsError.unwrapOptionField(
        "compilationTargetPlatformArch",
        compilationTargetPlatformArch
      )
    def getCompilationTargetPlatformAccelerator: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.TargetPlatformAccelerator
    ] = AwsError.unwrapOptionField(
      "compilationTargetPlatformAccelerator",
      compilationTargetPlatformAccelerator
    )
    def getLastModifiedTime: ZIO[Any, AwsError, LastModifiedTime] =
      AwsError.unwrapOptionField("lastModifiedTime", lastModifiedTime)
    def getCompilationJobStatus
        : ZIO[Any, Nothing, zio.aws.sagemaker.model.CompilationJobStatus] =
      ZIO.succeed(compilationJobStatus)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.CompilationJobSummary
  ) extends zio.aws.sagemaker.model.CompilationJobSummary.ReadOnly {
    override val compilationJobName: EntityName =
      zio.aws.sagemaker.model.primitives.EntityName(impl.compilationJobName())
    override val compilationJobArn: CompilationJobArn =
      zio.aws.sagemaker.model.primitives
        .CompilationJobArn(impl.compilationJobArn())
    override val creationTime: CreationTime =
      zio.aws.sagemaker.model.primitives.CreationTime(impl.creationTime())
    override val compilationStartTime: Option[Timestamp] = scala
      .Option(impl.compilationStartTime())
      .map(value => zio.aws.sagemaker.model.primitives.Timestamp(value))
    override val compilationEndTime: Option[Timestamp] = scala
      .Option(impl.compilationEndTime())
      .map(value => zio.aws.sagemaker.model.primitives.Timestamp(value))
    override val compilationTargetDevice
        : Option[zio.aws.sagemaker.model.TargetDevice] = scala
      .Option(impl.compilationTargetDevice())
      .map(value => zio.aws.sagemaker.model.TargetDevice.wrap(value))
    override val compilationTargetPlatformOs
        : Option[zio.aws.sagemaker.model.TargetPlatformOs] = scala
      .Option(impl.compilationTargetPlatformOs())
      .map(value => zio.aws.sagemaker.model.TargetPlatformOs.wrap(value))
    override val compilationTargetPlatformArch
        : Option[zio.aws.sagemaker.model.TargetPlatformArch] = scala
      .Option(impl.compilationTargetPlatformArch())
      .map(value => zio.aws.sagemaker.model.TargetPlatformArch.wrap(value))
    override val compilationTargetPlatformAccelerator
        : Option[zio.aws.sagemaker.model.TargetPlatformAccelerator] = scala
      .Option(impl.compilationTargetPlatformAccelerator())
      .map(value =>
        zio.aws.sagemaker.model.TargetPlatformAccelerator.wrap(value)
      )
    override val lastModifiedTime: Option[LastModifiedTime] = scala
      .Option(impl.lastModifiedTime())
      .map(value => zio.aws.sagemaker.model.primitives.LastModifiedTime(value))
    override val compilationJobStatus
        : zio.aws.sagemaker.model.CompilationJobStatus =
      zio.aws.sagemaker.model.CompilationJobStatus
        .wrap(impl.compilationJobStatus())
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.CompilationJobSummary
  ): zio.aws.sagemaker.model.CompilationJobSummary.ReadOnly = new Wrapper(impl)
}
