package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.sagemaker.model.primitives.{ContentType, ChannelName}
import scala.jdk.CollectionConverters.*
final case class Channel(
    channelName: ChannelName,
    dataSource: zio.aws.sagemaker.model.DataSource,
    contentType: Option[ContentType] = None,
    compressionType: Option[zio.aws.sagemaker.model.CompressionType] = None,
    recordWrapperType: Option[zio.aws.sagemaker.model.RecordWrapper] = None,
    inputMode: Option[zio.aws.sagemaker.model.TrainingInputMode] = None,
    shuffleConfig: Option[zio.aws.sagemaker.model.ShuffleConfig] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.Channel = {
    import Channel.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.Channel
      .builder()
      .channelName(ChannelName.unwrap(channelName): java.lang.String)
      .dataSource(dataSource.buildAwsValue())
      .optionallyWith(
        contentType.map(value => ContentType.unwrap(value): java.lang.String)
      )(_.contentType)
      .optionallyWith(compressionType.map(value => value.unwrap))(
        _.compressionType
      )
      .optionallyWith(recordWrapperType.map(value => value.unwrap))(
        _.recordWrapperType
      )
      .optionallyWith(inputMode.map(value => value.unwrap))(_.inputMode)
      .optionallyWith(shuffleConfig.map(value => value.buildAwsValue()))(
        _.shuffleConfig
      )
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.Channel.ReadOnly =
    zio.aws.sagemaker.model.Channel.wrap(buildAwsValue())
}
object Channel {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.sagemaker.model.Channel] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.Channel =
      zio.aws.sagemaker.model.Channel(
        channelName,
        dataSource.asEditable,
        contentType.map(value => value),
        compressionType.map(value => value),
        recordWrapperType.map(value => value),
        inputMode.map(value => value),
        shuffleConfig.map(value => value.asEditable)
      )
    def channelName: ChannelName
    def dataSource: zio.aws.sagemaker.model.DataSource.ReadOnly
    def contentType: Option[ContentType]
    def compressionType: Option[zio.aws.sagemaker.model.CompressionType]
    def recordWrapperType: Option[zio.aws.sagemaker.model.RecordWrapper]
    def inputMode: Option[zio.aws.sagemaker.model.TrainingInputMode]
    def shuffleConfig: Option[zio.aws.sagemaker.model.ShuffleConfig.ReadOnly]
    def getChannelName: ZIO[Any, Nothing, ChannelName] =
      ZIO.succeed(channelName)
    def getDataSource
        : ZIO[Any, Nothing, zio.aws.sagemaker.model.DataSource.ReadOnly] =
      ZIO.succeed(dataSource)
    def getContentType: ZIO[Any, AwsError, ContentType] =
      AwsError.unwrapOptionField("contentType", contentType)
    def getCompressionType
        : ZIO[Any, AwsError, zio.aws.sagemaker.model.CompressionType] =
      AwsError.unwrapOptionField("compressionType", compressionType)
    def getRecordWrapperType
        : ZIO[Any, AwsError, zio.aws.sagemaker.model.RecordWrapper] =
      AwsError.unwrapOptionField("recordWrapperType", recordWrapperType)
    def getInputMode
        : ZIO[Any, AwsError, zio.aws.sagemaker.model.TrainingInputMode] =
      AwsError.unwrapOptionField("inputMode", inputMode)
    def getShuffleConfig
        : ZIO[Any, AwsError, zio.aws.sagemaker.model.ShuffleConfig.ReadOnly] =
      AwsError.unwrapOptionField("shuffleConfig", shuffleConfig)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.Channel
  ) extends zio.aws.sagemaker.model.Channel.ReadOnly {
    override val channelName: ChannelName =
      zio.aws.sagemaker.model.primitives.ChannelName(impl.channelName())
    override val dataSource: zio.aws.sagemaker.model.DataSource.ReadOnly =
      zio.aws.sagemaker.model.DataSource.wrap(impl.dataSource())
    override val contentType: Option[ContentType] = scala
      .Option(impl.contentType())
      .map(value => zio.aws.sagemaker.model.primitives.ContentType(value))
    override val compressionType
        : Option[zio.aws.sagemaker.model.CompressionType] = scala
      .Option(impl.compressionType())
      .map(value => zio.aws.sagemaker.model.CompressionType.wrap(value))
    override val recordWrapperType
        : Option[zio.aws.sagemaker.model.RecordWrapper] = scala
      .Option(impl.recordWrapperType())
      .map(value => zio.aws.sagemaker.model.RecordWrapper.wrap(value))
    override val inputMode: Option[zio.aws.sagemaker.model.TrainingInputMode] =
      scala
        .Option(impl.inputMode())
        .map(value => zio.aws.sagemaker.model.TrainingInputMode.wrap(value))
    override val shuffleConfig
        : Option[zio.aws.sagemaker.model.ShuffleConfig.ReadOnly] = scala
      .Option(impl.shuffleConfig())
      .map(value => zio.aws.sagemaker.model.ShuffleConfig.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.Channel
  ): zio.aws.sagemaker.model.Channel.ReadOnly = new Wrapper(impl)
}
