package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.sagemaker.model.primitives.{
  EnableIotRoleAlias,
  DeviceFleetDescription,
  RoleArn,
  EntityName
}
import scala.jdk.CollectionConverters.*
final case class UpdateDeviceFleetRequest(
    deviceFleetName: EntityName,
    roleArn: Option[RoleArn] = None,
    description: Option[DeviceFleetDescription] = None,
    outputConfig: zio.aws.sagemaker.model.EdgeOutputConfig,
    enableIotRoleAlias: Option[EnableIotRoleAlias] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.UpdateDeviceFleetRequest = {
    import UpdateDeviceFleetRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.UpdateDeviceFleetRequest
      .builder()
      .deviceFleetName(EntityName.unwrap(deviceFleetName): java.lang.String)
      .optionallyWith(
        roleArn.map(value => RoleArn.unwrap(value): java.lang.String)
      )(_.roleArn)
      .optionallyWith(
        description.map(value =>
          DeviceFleetDescription.unwrap(value): java.lang.String
        )
      )(_.description)
      .outputConfig(outputConfig.buildAwsValue())
      .optionallyWith(
        enableIotRoleAlias.map(value =>
          EnableIotRoleAlias.unwrap(value): java.lang.Boolean
        )
      )(_.enableIotRoleAlias)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.UpdateDeviceFleetRequest.ReadOnly =
    zio.aws.sagemaker.model.UpdateDeviceFleetRequest.wrap(buildAwsValue())
}
object UpdateDeviceFleetRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.UpdateDeviceFleetRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.UpdateDeviceFleetRequest =
      zio.aws.sagemaker.model.UpdateDeviceFleetRequest(
        deviceFleetName,
        roleArn.map(value => value),
        description.map(value => value),
        outputConfig.asEditable,
        enableIotRoleAlias.map(value => value)
      )
    def deviceFleetName: EntityName
    def roleArn: Option[RoleArn]
    def description: Option[DeviceFleetDescription]
    def outputConfig: zio.aws.sagemaker.model.EdgeOutputConfig.ReadOnly
    def enableIotRoleAlias: Option[EnableIotRoleAlias]
    def getDeviceFleetName: ZIO[Any, Nothing, EntityName] =
      ZIO.succeed(deviceFleetName)
    def getRoleArn: ZIO[Any, AwsError, RoleArn] =
      AwsError.unwrapOptionField("roleArn", roleArn)
    def getDescription: ZIO[Any, AwsError, DeviceFleetDescription] =
      AwsError.unwrapOptionField("description", description)
    def getOutputConfig
        : ZIO[Any, Nothing, zio.aws.sagemaker.model.EdgeOutputConfig.ReadOnly] =
      ZIO.succeed(outputConfig)
    def getEnableIotRoleAlias: ZIO[Any, AwsError, EnableIotRoleAlias] =
      AwsError.unwrapOptionField("enableIotRoleAlias", enableIotRoleAlias)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.UpdateDeviceFleetRequest
  ) extends zio.aws.sagemaker.model.UpdateDeviceFleetRequest.ReadOnly {
    override val deviceFleetName: EntityName =
      zio.aws.sagemaker.model.primitives.EntityName(impl.deviceFleetName())
    override val roleArn: Option[RoleArn] = scala
      .Option(impl.roleArn())
      .map(value => zio.aws.sagemaker.model.primitives.RoleArn(value))
    override val description: Option[DeviceFleetDescription] = scala
      .Option(impl.description())
      .map(value =>
        zio.aws.sagemaker.model.primitives.DeviceFleetDescription(value)
      )
    override val outputConfig
        : zio.aws.sagemaker.model.EdgeOutputConfig.ReadOnly =
      zio.aws.sagemaker.model.EdgeOutputConfig.wrap(impl.outputConfig())
    override val enableIotRoleAlias: Option[EnableIotRoleAlias] = scala
      .Option(impl.enableIotRoleAlias())
      .map(value =>
        zio.aws.sagemaker.model.primitives.EnableIotRoleAlias(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.UpdateDeviceFleetRequest
  ): zio.aws.sagemaker.model.UpdateDeviceFleetRequest.ReadOnly = new Wrapper(
    impl
  )
}
