package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.sagemaker.model.primitives.{SourceType, TrialSourceArn}
import scala.jdk.CollectionConverters.*
final case class TrialSource(
    sourceArn: TrialSourceArn,
    sourceType: Option[SourceType] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.TrialSource = {
    import TrialSource.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.TrialSource
      .builder()
      .sourceArn(TrialSourceArn.unwrap(sourceArn): java.lang.String)
      .optionallyWith(
        sourceType.map(value => SourceType.unwrap(value): java.lang.String)
      )(_.sourceType)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.TrialSource.ReadOnly =
    zio.aws.sagemaker.model.TrialSource.wrap(buildAwsValue())
}
object TrialSource {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.TrialSource
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.TrialSource =
      zio.aws.sagemaker.model
        .TrialSource(sourceArn, sourceType.map(value => value))
    def sourceArn: TrialSourceArn
    def sourceType: Option[SourceType]
    def getSourceArn: ZIO[Any, Nothing, TrialSourceArn] = ZIO.succeed(sourceArn)
    def getSourceType: ZIO[Any, AwsError, SourceType] =
      AwsError.unwrapOptionField("sourceType", sourceType)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.TrialSource
  ) extends zio.aws.sagemaker.model.TrialSource.ReadOnly {
    override val sourceArn: TrialSourceArn =
      zio.aws.sagemaker.model.primitives.TrialSourceArn(impl.sourceArn())
    override val sourceType: Option[SourceType] = scala
      .Option(impl.sourceType())
      .map(value => zio.aws.sagemaker.model.primitives.SourceType(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.TrialSource
  ): zio.aws.sagemaker.model.TrialSource.ReadOnly = new Wrapper(impl)
}
