package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.sagemaker.model.primitives.TrialComponentStatusMessage
import scala.jdk.CollectionConverters.*
final case class TrialComponentStatus(
    primaryStatus: Option[zio.aws.sagemaker.model.TrialComponentPrimaryStatus] =
      None,
    message: Option[TrialComponentStatusMessage] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.TrialComponentStatus = {
    import TrialComponentStatus.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.TrialComponentStatus
      .builder()
      .optionallyWith(primaryStatus.map(value => value.unwrap))(_.primaryStatus)
      .optionallyWith(
        message.map(value =>
          TrialComponentStatusMessage.unwrap(value): java.lang.String
        )
      )(_.message)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.TrialComponentStatus.ReadOnly =
    zio.aws.sagemaker.model.TrialComponentStatus.wrap(buildAwsValue())
}
object TrialComponentStatus {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.TrialComponentStatus
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.TrialComponentStatus =
      zio.aws.sagemaker.model.TrialComponentStatus(
        primaryStatus.map(value => value),
        message.map(value => value)
      )
    def primaryStatus
        : Option[zio.aws.sagemaker.model.TrialComponentPrimaryStatus]
    def message: Option[TrialComponentStatusMessage]
    def getPrimaryStatus: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.TrialComponentPrimaryStatus
    ] = AwsError.unwrapOptionField("primaryStatus", primaryStatus)
    def getMessage: ZIO[Any, AwsError, TrialComponentStatusMessage] =
      AwsError.unwrapOptionField("message", message)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.TrialComponentStatus
  ) extends zio.aws.sagemaker.model.TrialComponentStatus.ReadOnly {
    override val primaryStatus
        : Option[zio.aws.sagemaker.model.TrialComponentPrimaryStatus] = scala
      .Option(impl.primaryStatus())
      .map(value =>
        zio.aws.sagemaker.model.TrialComponentPrimaryStatus.wrap(value)
      )
    override val message: Option[TrialComponentStatusMessage] = scala
      .Option(impl.message())
      .map(value =>
        zio.aws.sagemaker.model.primitives.TrialComponentStatusMessage(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.TrialComponentStatus
  ): zio.aws.sagemaker.model.TrialComponentStatus.ReadOnly = new Wrapper(impl)
}
