package zio.aws.sagemaker.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.sagemaker.model.primitives.{
  MaxResults,
  NextToken,
  ResourcePropertyName
}
import scala.jdk.CollectionConverters.*
final case class SearchRequest(
    resource: zio.aws.sagemaker.model.ResourceType,
    searchExpression: Option[zio.aws.sagemaker.model.SearchExpression] = None,
    sortBy: Option[ResourcePropertyName] = None,
    sortOrder: Option[zio.aws.sagemaker.model.SearchSortOrder] = None,
    nextToken: Option[NextToken] = None,
    maxResults: Option[MaxResults] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.SearchRequest = {
    import SearchRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.SearchRequest
      .builder()
      .resource(resource.unwrap)
      .optionallyWith(searchExpression.map(value => value.buildAwsValue()))(
        _.searchExpression
      )
      .optionallyWith(
        sortBy.map(value =>
          ResourcePropertyName.unwrap(value): java.lang.String
        )
      )(_.sortBy)
      .optionallyWith(sortOrder.map(value => value.unwrap))(_.sortOrder)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.SearchRequest.ReadOnly =
    zio.aws.sagemaker.model.SearchRequest.wrap(buildAwsValue())
}
object SearchRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.SearchRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.SearchRequest =
      zio.aws.sagemaker.model.SearchRequest(
        resource,
        searchExpression.map(value => value.asEditable),
        sortBy.map(value => value),
        sortOrder.map(value => value),
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def resource: zio.aws.sagemaker.model.ResourceType
    def searchExpression
        : Option[zio.aws.sagemaker.model.SearchExpression.ReadOnly]
    def sortBy: Option[ResourcePropertyName]
    def sortOrder: Option[zio.aws.sagemaker.model.SearchSortOrder]
    def nextToken: Option[NextToken]
    def maxResults: Option[MaxResults]
    def getResource: ZIO[Any, Nothing, zio.aws.sagemaker.model.ResourceType] =
      ZIO.succeed(resource)
    def getSearchExpression: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.SearchExpression.ReadOnly
    ] = AwsError.unwrapOptionField("searchExpression", searchExpression)
    def getSortBy: ZIO[Any, AwsError, ResourcePropertyName] =
      AwsError.unwrapOptionField("sortBy", sortBy)
    def getSortOrder
        : ZIO[Any, AwsError, zio.aws.sagemaker.model.SearchSortOrder] =
      AwsError.unwrapOptionField("sortOrder", sortOrder)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.SearchRequest
  ) extends zio.aws.sagemaker.model.SearchRequest.ReadOnly {
    override val resource: zio.aws.sagemaker.model.ResourceType =
      zio.aws.sagemaker.model.ResourceType.wrap(impl.resource())
    override val searchExpression
        : Option[zio.aws.sagemaker.model.SearchExpression.ReadOnly] = scala
      .Option(impl.searchExpression())
      .map(value => zio.aws.sagemaker.model.SearchExpression.wrap(value))
    override val sortBy: Option[ResourcePropertyName] = scala
      .Option(impl.sortBy())
      .map(value =>
        zio.aws.sagemaker.model.primitives.ResourcePropertyName(value)
      )
    override val sortOrder: Option[zio.aws.sagemaker.model.SearchSortOrder] =
      scala
        .Option(impl.sortOrder())
        .map(value => zio.aws.sagemaker.model.SearchSortOrder.wrap(value))
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.sagemaker.model.primitives.NextToken(value))
    override val maxResults: Option[MaxResults] = scala
      .Option(impl.maxResults())
      .map(value => zio.aws.sagemaker.model.primitives.MaxResults(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.SearchRequest
  ): zio.aws.sagemaker.model.SearchRequest.ReadOnly = new Wrapper(impl)
}
