package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class SearchRecord(
    trainingJob: Option[zio.aws.sagemaker.model.TrainingJob] = None,
    experiment: Option[zio.aws.sagemaker.model.Experiment] = None,
    trial: Option[zio.aws.sagemaker.model.Trial] = None,
    trialComponent: Option[zio.aws.sagemaker.model.TrialComponent] = None,
    endpoint: Option[zio.aws.sagemaker.model.Endpoint] = None,
    modelPackage: Option[zio.aws.sagemaker.model.ModelPackage] = None,
    modelPackageGroup: Option[zio.aws.sagemaker.model.ModelPackageGroup] = None,
    pipeline: Option[zio.aws.sagemaker.model.Pipeline] = None,
    pipelineExecution: Option[zio.aws.sagemaker.model.PipelineExecution] = None,
    featureGroup: Option[zio.aws.sagemaker.model.FeatureGroup] = None,
    project: Option[zio.aws.sagemaker.model.Project] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.SearchRecord = {
    import SearchRecord.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.SearchRecord
      .builder()
      .optionallyWith(trainingJob.map(value => value.buildAwsValue()))(
        _.trainingJob
      )
      .optionallyWith(experiment.map(value => value.buildAwsValue()))(
        _.experiment
      )
      .optionallyWith(trial.map(value => value.buildAwsValue()))(_.trial)
      .optionallyWith(trialComponent.map(value => value.buildAwsValue()))(
        _.trialComponent
      )
      .optionallyWith(endpoint.map(value => value.buildAwsValue()))(_.endpoint)
      .optionallyWith(modelPackage.map(value => value.buildAwsValue()))(
        _.modelPackage
      )
      .optionallyWith(modelPackageGroup.map(value => value.buildAwsValue()))(
        _.modelPackageGroup
      )
      .optionallyWith(pipeline.map(value => value.buildAwsValue()))(_.pipeline)
      .optionallyWith(pipelineExecution.map(value => value.buildAwsValue()))(
        _.pipelineExecution
      )
      .optionallyWith(featureGroup.map(value => value.buildAwsValue()))(
        _.featureGroup
      )
      .optionallyWith(project.map(value => value.buildAwsValue()))(_.project)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.SearchRecord.ReadOnly =
    zio.aws.sagemaker.model.SearchRecord.wrap(buildAwsValue())
}
object SearchRecord {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.SearchRecord
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.SearchRecord =
      zio.aws.sagemaker.model.SearchRecord(
        trainingJob.map(value => value.asEditable),
        experiment.map(value => value.asEditable),
        trial.map(value => value.asEditable),
        trialComponent.map(value => value.asEditable),
        endpoint.map(value => value.asEditable),
        modelPackage.map(value => value.asEditable),
        modelPackageGroup.map(value => value.asEditable),
        pipeline.map(value => value.asEditable),
        pipelineExecution.map(value => value.asEditable),
        featureGroup.map(value => value.asEditable),
        project.map(value => value.asEditable)
      )
    def trainingJob: Option[zio.aws.sagemaker.model.TrainingJob.ReadOnly]
    def experiment: Option[zio.aws.sagemaker.model.Experiment.ReadOnly]
    def trial: Option[zio.aws.sagemaker.model.Trial.ReadOnly]
    def trialComponent: Option[zio.aws.sagemaker.model.TrialComponent.ReadOnly]
    def endpoint: Option[zio.aws.sagemaker.model.Endpoint.ReadOnly]
    def modelPackage: Option[zio.aws.sagemaker.model.ModelPackage.ReadOnly]
    def modelPackageGroup
        : Option[zio.aws.sagemaker.model.ModelPackageGroup.ReadOnly]
    def pipeline: Option[zio.aws.sagemaker.model.Pipeline.ReadOnly]
    def pipelineExecution
        : Option[zio.aws.sagemaker.model.PipelineExecution.ReadOnly]
    def featureGroup: Option[zio.aws.sagemaker.model.FeatureGroup.ReadOnly]
    def project: Option[zio.aws.sagemaker.model.Project.ReadOnly]
    def getTrainingJob
        : ZIO[Any, AwsError, zio.aws.sagemaker.model.TrainingJob.ReadOnly] =
      AwsError.unwrapOptionField("trainingJob", trainingJob)
    def getExperiment
        : ZIO[Any, AwsError, zio.aws.sagemaker.model.Experiment.ReadOnly] =
      AwsError.unwrapOptionField("experiment", experiment)
    def getTrial: ZIO[Any, AwsError, zio.aws.sagemaker.model.Trial.ReadOnly] =
      AwsError.unwrapOptionField("trial", trial)
    def getTrialComponent
        : ZIO[Any, AwsError, zio.aws.sagemaker.model.TrialComponent.ReadOnly] =
      AwsError.unwrapOptionField("trialComponent", trialComponent)
    def getEndpoint
        : ZIO[Any, AwsError, zio.aws.sagemaker.model.Endpoint.ReadOnly] =
      AwsError.unwrapOptionField("endpoint", endpoint)
    def getModelPackage
        : ZIO[Any, AwsError, zio.aws.sagemaker.model.ModelPackage.ReadOnly] =
      AwsError.unwrapOptionField("modelPackage", modelPackage)
    def getModelPackageGroup: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.ModelPackageGroup.ReadOnly
    ] = AwsError.unwrapOptionField("modelPackageGroup", modelPackageGroup)
    def getPipeline
        : ZIO[Any, AwsError, zio.aws.sagemaker.model.Pipeline.ReadOnly] =
      AwsError.unwrapOptionField("pipeline", pipeline)
    def getPipelineExecution: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.PipelineExecution.ReadOnly
    ] = AwsError.unwrapOptionField("pipelineExecution", pipelineExecution)
    def getFeatureGroup
        : ZIO[Any, AwsError, zio.aws.sagemaker.model.FeatureGroup.ReadOnly] =
      AwsError.unwrapOptionField("featureGroup", featureGroup)
    def getProject
        : ZIO[Any, AwsError, zio.aws.sagemaker.model.Project.ReadOnly] =
      AwsError.unwrapOptionField("project", project)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.SearchRecord
  ) extends zio.aws.sagemaker.model.SearchRecord.ReadOnly {
    override val trainingJob
        : Option[zio.aws.sagemaker.model.TrainingJob.ReadOnly] = scala
      .Option(impl.trainingJob())
      .map(value => zio.aws.sagemaker.model.TrainingJob.wrap(value))
    override val experiment
        : Option[zio.aws.sagemaker.model.Experiment.ReadOnly] = scala
      .Option(impl.experiment())
      .map(value => zio.aws.sagemaker.model.Experiment.wrap(value))
    override val trial: Option[zio.aws.sagemaker.model.Trial.ReadOnly] = scala
      .Option(impl.trial())
      .map(value => zio.aws.sagemaker.model.Trial.wrap(value))
    override val trialComponent
        : Option[zio.aws.sagemaker.model.TrialComponent.ReadOnly] = scala
      .Option(impl.trialComponent())
      .map(value => zio.aws.sagemaker.model.TrialComponent.wrap(value))
    override val endpoint: Option[zio.aws.sagemaker.model.Endpoint.ReadOnly] =
      scala
        .Option(impl.endpoint())
        .map(value => zio.aws.sagemaker.model.Endpoint.wrap(value))
    override val modelPackage
        : Option[zio.aws.sagemaker.model.ModelPackage.ReadOnly] = scala
      .Option(impl.modelPackage())
      .map(value => zio.aws.sagemaker.model.ModelPackage.wrap(value))
    override val modelPackageGroup
        : Option[zio.aws.sagemaker.model.ModelPackageGroup.ReadOnly] = scala
      .Option(impl.modelPackageGroup())
      .map(value => zio.aws.sagemaker.model.ModelPackageGroup.wrap(value))
    override val pipeline: Option[zio.aws.sagemaker.model.Pipeline.ReadOnly] =
      scala
        .Option(impl.pipeline())
        .map(value => zio.aws.sagemaker.model.Pipeline.wrap(value))
    override val pipelineExecution
        : Option[zio.aws.sagemaker.model.PipelineExecution.ReadOnly] = scala
      .Option(impl.pipelineExecution())
      .map(value => zio.aws.sagemaker.model.PipelineExecution.wrap(value))
    override val featureGroup
        : Option[zio.aws.sagemaker.model.FeatureGroup.ReadOnly] = scala
      .Option(impl.featureGroup())
      .map(value => zio.aws.sagemaker.model.FeatureGroup.wrap(value))
    override val project: Option[zio.aws.sagemaker.model.Project.ReadOnly] =
      scala
        .Option(impl.project())
        .map(value => zio.aws.sagemaker.model.Project.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.SearchRecord
  ): zio.aws.sagemaker.model.SearchRecord.ReadOnly = new Wrapper(impl)
}
