package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.sagemaker.model.primitives.RoleArn
import scala.jdk.CollectionConverters.*
final case class RStudioServerProDomainSettings(
    domainExecutionRoleArn: RoleArn,
    rStudioConnectUrl: Option[String] = None,
    rStudioPackageManagerUrl: Option[String] = None,
    defaultResourceSpec: Option[zio.aws.sagemaker.model.ResourceSpec] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.RStudioServerProDomainSettings = {
    import RStudioServerProDomainSettings.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.RStudioServerProDomainSettings
      .builder()
      .domainExecutionRoleArn(
        RoleArn.unwrap(domainExecutionRoleArn): java.lang.String
      )
      .optionallyWith(rStudioConnectUrl.map(value => value: java.lang.String))(
        _.rStudioConnectUrl
      )
      .optionallyWith(
        rStudioPackageManagerUrl.map(value => value: java.lang.String)
      )(_.rStudioPackageManagerUrl)
      .optionallyWith(defaultResourceSpec.map(value => value.buildAwsValue()))(
        _.defaultResourceSpec
      )
      .build()
  }
  def asReadOnly
      : zio.aws.sagemaker.model.RStudioServerProDomainSettings.ReadOnly =
    zio.aws.sagemaker.model.RStudioServerProDomainSettings.wrap(buildAwsValue())
}
object RStudioServerProDomainSettings {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.RStudioServerProDomainSettings
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.RStudioServerProDomainSettings =
      zio.aws.sagemaker.model.RStudioServerProDomainSettings(
        domainExecutionRoleArn,
        rStudioConnectUrl.map(value => value),
        rStudioPackageManagerUrl.map(value => value),
        defaultResourceSpec.map(value => value.asEditable)
      )
    def domainExecutionRoleArn: RoleArn
    def rStudioConnectUrl: Option[String]
    def rStudioPackageManagerUrl: Option[String]
    def defaultResourceSpec
        : Option[zio.aws.sagemaker.model.ResourceSpec.ReadOnly]
    def getDomainExecutionRoleArn: ZIO[Any, Nothing, RoleArn] =
      ZIO.succeed(domainExecutionRoleArn)
    def getRStudioConnectUrl: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("rStudioConnectUrl", rStudioConnectUrl)
    def getRStudioPackageManagerUrl: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("rStudioPackageManagerUrl", rStudioPackageManagerUrl)
    def getDefaultResourceSpec
        : ZIO[Any, AwsError, zio.aws.sagemaker.model.ResourceSpec.ReadOnly] =
      AwsError.unwrapOptionField("defaultResourceSpec", defaultResourceSpec)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.RStudioServerProDomainSettings
  ) extends zio.aws.sagemaker.model.RStudioServerProDomainSettings.ReadOnly {
    override val domainExecutionRoleArn: RoleArn =
      zio.aws.sagemaker.model.primitives.RoleArn(impl.domainExecutionRoleArn())
    override val rStudioConnectUrl: Option[String] =
      scala.Option(impl.rStudioConnectUrl()).map(value => value: String)
    override val rStudioPackageManagerUrl: Option[String] =
      scala.Option(impl.rStudioPackageManagerUrl()).map(value => value: String)
    override val defaultResourceSpec
        : Option[zio.aws.sagemaker.model.ResourceSpec.ReadOnly] = scala
      .Option(impl.defaultResourceSpec())
      .map(value => zio.aws.sagemaker.model.ResourceSpec.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.RStudioServerProDomainSettings
  ): zio.aws.sagemaker.model.RStudioServerProDomainSettings.ReadOnly =
    new Wrapper(impl)
}
