package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ParameterRange(
    integerParameterRangeSpecification: Option[
      zio.aws.sagemaker.model.IntegerParameterRangeSpecification
    ] = None,
    continuousParameterRangeSpecification: Option[
      zio.aws.sagemaker.model.ContinuousParameterRangeSpecification
    ] = None,
    categoricalParameterRangeSpecification: Option[
      zio.aws.sagemaker.model.CategoricalParameterRangeSpecification
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.ParameterRange = {
    import ParameterRange.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.ParameterRange
      .builder()
      .optionallyWith(
        integerParameterRangeSpecification.map(value => value.buildAwsValue())
      )(_.integerParameterRangeSpecification)
      .optionallyWith(
        continuousParameterRangeSpecification.map(value =>
          value.buildAwsValue()
        )
      )(_.continuousParameterRangeSpecification)
      .optionallyWith(
        categoricalParameterRangeSpecification.map(value =>
          value.buildAwsValue()
        )
      )(_.categoricalParameterRangeSpecification)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.ParameterRange.ReadOnly =
    zio.aws.sagemaker.model.ParameterRange.wrap(buildAwsValue())
}
object ParameterRange {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.ParameterRange
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.ParameterRange =
      zio.aws.sagemaker.model.ParameterRange(
        integerParameterRangeSpecification.map(value => value.asEditable),
        continuousParameterRangeSpecification.map(value => value.asEditable),
        categoricalParameterRangeSpecification.map(value => value.asEditable)
      )
    def integerParameterRangeSpecification: Option[
      zio.aws.sagemaker.model.IntegerParameterRangeSpecification.ReadOnly
    ]
    def continuousParameterRangeSpecification: Option[
      zio.aws.sagemaker.model.ContinuousParameterRangeSpecification.ReadOnly
    ]
    def categoricalParameterRangeSpecification: Option[
      zio.aws.sagemaker.model.CategoricalParameterRangeSpecification.ReadOnly
    ]
    def getIntegerParameterRangeSpecification: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.IntegerParameterRangeSpecification.ReadOnly
    ] = AwsError.unwrapOptionField(
      "integerParameterRangeSpecification",
      integerParameterRangeSpecification
    )
    def getContinuousParameterRangeSpecification: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.ContinuousParameterRangeSpecification.ReadOnly
    ] = AwsError.unwrapOptionField(
      "continuousParameterRangeSpecification",
      continuousParameterRangeSpecification
    )
    def getCategoricalParameterRangeSpecification: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.CategoricalParameterRangeSpecification.ReadOnly
    ] = AwsError.unwrapOptionField(
      "categoricalParameterRangeSpecification",
      categoricalParameterRangeSpecification
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.ParameterRange
  ) extends zio.aws.sagemaker.model.ParameterRange.ReadOnly {
    override val integerParameterRangeSpecification: Option[
      zio.aws.sagemaker.model.IntegerParameterRangeSpecification.ReadOnly
    ] = scala
      .Option(impl.integerParameterRangeSpecification())
      .map(value =>
        zio.aws.sagemaker.model.IntegerParameterRangeSpecification.wrap(value)
      )
    override val continuousParameterRangeSpecification: Option[
      zio.aws.sagemaker.model.ContinuousParameterRangeSpecification.ReadOnly
    ] = scala
      .Option(impl.continuousParameterRangeSpecification())
      .map(value =>
        zio.aws.sagemaker.model.ContinuousParameterRangeSpecification
          .wrap(value)
      )
    override val categoricalParameterRangeSpecification: Option[
      zio.aws.sagemaker.model.CategoricalParameterRangeSpecification.ReadOnly
    ] = scala
      .Option(impl.categoricalParameterRangeSpecification())
      .map(value =>
        zio.aws.sagemaker.model.CategoricalParameterRangeSpecification
          .wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.ParameterRange
  ): zio.aws.sagemaker.model.ParameterRange.ReadOnly = new Wrapper(impl)
}
