package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.sagemaker.model.primitives.{KmsKeyId, CompilerOptions, S3Uri}
import scala.jdk.CollectionConverters.*
final case class OutputConfig(
    s3OutputLocation: S3Uri,
    targetDevice: Option[zio.aws.sagemaker.model.TargetDevice] = None,
    targetPlatform: Option[zio.aws.sagemaker.model.TargetPlatform] = None,
    compilerOptions: Option[CompilerOptions] = None,
    kmsKeyId: Option[KmsKeyId] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.OutputConfig = {
    import OutputConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.OutputConfig
      .builder()
      .s3OutputLocation(S3Uri.unwrap(s3OutputLocation): java.lang.String)
      .optionallyWith(targetDevice.map(value => value.unwrap))(_.targetDevice)
      .optionallyWith(targetPlatform.map(value => value.buildAwsValue()))(
        _.targetPlatform
      )
      .optionallyWith(
        compilerOptions.map(value =>
          CompilerOptions.unwrap(value): java.lang.String
        )
      )(_.compilerOptions)
      .optionallyWith(
        kmsKeyId.map(value => KmsKeyId.unwrap(value): java.lang.String)
      )(_.kmsKeyId)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.OutputConfig.ReadOnly =
    zio.aws.sagemaker.model.OutputConfig.wrap(buildAwsValue())
}
object OutputConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.OutputConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.OutputConfig =
      zio.aws.sagemaker.model.OutputConfig(
        s3OutputLocation,
        targetDevice.map(value => value),
        targetPlatform.map(value => value.asEditable),
        compilerOptions.map(value => value),
        kmsKeyId.map(value => value)
      )
    def s3OutputLocation: S3Uri
    def targetDevice: Option[zio.aws.sagemaker.model.TargetDevice]
    def targetPlatform: Option[zio.aws.sagemaker.model.TargetPlatform.ReadOnly]
    def compilerOptions: Option[CompilerOptions]
    def kmsKeyId: Option[KmsKeyId]
    def getS3OutputLocation: ZIO[Any, Nothing, S3Uri] =
      ZIO.succeed(s3OutputLocation)
    def getTargetDevice
        : ZIO[Any, AwsError, zio.aws.sagemaker.model.TargetDevice] =
      AwsError.unwrapOptionField("targetDevice", targetDevice)
    def getTargetPlatform
        : ZIO[Any, AwsError, zio.aws.sagemaker.model.TargetPlatform.ReadOnly] =
      AwsError.unwrapOptionField("targetPlatform", targetPlatform)
    def getCompilerOptions: ZIO[Any, AwsError, CompilerOptions] =
      AwsError.unwrapOptionField("compilerOptions", compilerOptions)
    def getKmsKeyId: ZIO[Any, AwsError, KmsKeyId] =
      AwsError.unwrapOptionField("kmsKeyId", kmsKeyId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.OutputConfig
  ) extends zio.aws.sagemaker.model.OutputConfig.ReadOnly {
    override val s3OutputLocation: S3Uri =
      zio.aws.sagemaker.model.primitives.S3Uri(impl.s3OutputLocation())
    override val targetDevice: Option[zio.aws.sagemaker.model.TargetDevice] =
      scala
        .Option(impl.targetDevice())
        .map(value => zio.aws.sagemaker.model.TargetDevice.wrap(value))
    override val targetPlatform
        : Option[zio.aws.sagemaker.model.TargetPlatform.ReadOnly] = scala
      .Option(impl.targetPlatform())
      .map(value => zio.aws.sagemaker.model.TargetPlatform.wrap(value))
    override val compilerOptions: Option[CompilerOptions] = scala
      .Option(impl.compilerOptions())
      .map(value => zio.aws.sagemaker.model.primitives.CompilerOptions(value))
    override val kmsKeyId: Option[KmsKeyId] = scala
      .Option(impl.kmsKeyId())
      .map(value => zio.aws.sagemaker.model.primitives.KmsKeyId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.OutputConfig
  ): zio.aws.sagemaker.model.OutputConfig.ReadOnly = new Wrapper(impl)
}
