package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import zio.aws.sagemaker.model.primitives.{
  EndpointName,
  MonitoringScheduleName,
  Timestamp,
  FailureReason,
  MonitoringScheduleArn
}
import scala.jdk.CollectionConverters.*
final case class MonitoringSchedule(
    monitoringScheduleArn: Option[MonitoringScheduleArn] = None,
    monitoringScheduleName: Option[MonitoringScheduleName] = None,
    monitoringScheduleStatus: Option[zio.aws.sagemaker.model.ScheduleStatus] =
      None,
    monitoringType: Option[zio.aws.sagemaker.model.MonitoringType] = None,
    failureReason: Option[FailureReason] = None,
    creationTime: Option[Timestamp] = None,
    lastModifiedTime: Option[Timestamp] = None,
    monitoringScheduleConfig: Option[
      zio.aws.sagemaker.model.MonitoringScheduleConfig
    ] = None,
    endpointName: Option[EndpointName] = None,
    lastMonitoringExecutionSummary: Option[
      zio.aws.sagemaker.model.MonitoringExecutionSummary
    ] = None,
    tags: Option[Iterable[zio.aws.sagemaker.model.Tag]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.MonitoringSchedule = {
    import MonitoringSchedule.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.MonitoringSchedule
      .builder()
      .optionallyWith(
        monitoringScheduleArn.map(value =>
          MonitoringScheduleArn.unwrap(value): java.lang.String
        )
      )(_.monitoringScheduleArn)
      .optionallyWith(
        monitoringScheduleName.map(value =>
          MonitoringScheduleName.unwrap(value): java.lang.String
        )
      )(_.monitoringScheduleName)
      .optionallyWith(monitoringScheduleStatus.map(value => value.unwrap))(
        _.monitoringScheduleStatus
      )
      .optionallyWith(monitoringType.map(value => value.unwrap))(
        _.monitoringType
      )
      .optionallyWith(
        failureReason.map(value =>
          FailureReason.unwrap(value): java.lang.String
        )
      )(_.failureReason)
      .optionallyWith(
        creationTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.creationTime)
      .optionallyWith(
        lastModifiedTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.lastModifiedTime)
      .optionallyWith(
        monitoringScheduleConfig.map(value => value.buildAwsValue())
      )(_.monitoringScheduleConfig)
      .optionallyWith(
        endpointName.map(value => EndpointName.unwrap(value): java.lang.String)
      )(_.endpointName)
      .optionallyWith(
        lastMonitoringExecutionSummary.map(value => value.buildAwsValue())
      )(_.lastMonitoringExecutionSummary)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.MonitoringSchedule.ReadOnly =
    zio.aws.sagemaker.model.MonitoringSchedule.wrap(buildAwsValue())
}
object MonitoringSchedule {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.MonitoringSchedule
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.MonitoringSchedule =
      zio.aws.sagemaker.model.MonitoringSchedule(
        monitoringScheduleArn.map(value => value),
        monitoringScheduleName.map(value => value),
        monitoringScheduleStatus.map(value => value),
        monitoringType.map(value => value),
        failureReason.map(value => value),
        creationTime.map(value => value),
        lastModifiedTime.map(value => value),
        monitoringScheduleConfig.map(value => value.asEditable),
        endpointName.map(value => value),
        lastMonitoringExecutionSummary.map(value => value.asEditable),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def monitoringScheduleArn: Option[MonitoringScheduleArn]
    def monitoringScheduleName: Option[MonitoringScheduleName]
    def monitoringScheduleStatus: Option[zio.aws.sagemaker.model.ScheduleStatus]
    def monitoringType: Option[zio.aws.sagemaker.model.MonitoringType]
    def failureReason: Option[FailureReason]
    def creationTime: Option[Timestamp]
    def lastModifiedTime: Option[Timestamp]
    def monitoringScheduleConfig
        : Option[zio.aws.sagemaker.model.MonitoringScheduleConfig.ReadOnly]
    def endpointName: Option[EndpointName]
    def lastMonitoringExecutionSummary
        : Option[zio.aws.sagemaker.model.MonitoringExecutionSummary.ReadOnly]
    def tags: Option[List[zio.aws.sagemaker.model.Tag.ReadOnly]]
    def getMonitoringScheduleArn: ZIO[Any, AwsError, MonitoringScheduleArn] =
      AwsError.unwrapOptionField("monitoringScheduleArn", monitoringScheduleArn)
    def getMonitoringScheduleName: ZIO[Any, AwsError, MonitoringScheduleName] =
      AwsError.unwrapOptionField(
        "monitoringScheduleName",
        monitoringScheduleName
      )
    def getMonitoringScheduleStatus
        : ZIO[Any, AwsError, zio.aws.sagemaker.model.ScheduleStatus] = AwsError
      .unwrapOptionField("monitoringScheduleStatus", monitoringScheduleStatus)
    def getMonitoringType
        : ZIO[Any, AwsError, zio.aws.sagemaker.model.MonitoringType] =
      AwsError.unwrapOptionField("monitoringType", monitoringType)
    def getFailureReason: ZIO[Any, AwsError, FailureReason] =
      AwsError.unwrapOptionField("failureReason", failureReason)
    def getCreationTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("creationTime", creationTime)
    def getLastModifiedTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("lastModifiedTime", lastModifiedTime)
    def getMonitoringScheduleConfig: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.MonitoringScheduleConfig.ReadOnly
    ] = AwsError.unwrapOptionField(
      "monitoringScheduleConfig",
      monitoringScheduleConfig
    )
    def getEndpointName: ZIO[Any, AwsError, EndpointName] =
      AwsError.unwrapOptionField("endpointName", endpointName)
    def getLastMonitoringExecutionSummary: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.MonitoringExecutionSummary.ReadOnly
    ] = AwsError.unwrapOptionField(
      "lastMonitoringExecutionSummary",
      lastMonitoringExecutionSummary
    )
    def getTags
        : ZIO[Any, AwsError, List[zio.aws.sagemaker.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.MonitoringSchedule
  ) extends zio.aws.sagemaker.model.MonitoringSchedule.ReadOnly {
    override val monitoringScheduleArn: Option[MonitoringScheduleArn] = scala
      .Option(impl.monitoringScheduleArn())
      .map(value =>
        zio.aws.sagemaker.model.primitives.MonitoringScheduleArn(value)
      )
    override val monitoringScheduleName: Option[MonitoringScheduleName] = scala
      .Option(impl.monitoringScheduleName())
      .map(value =>
        zio.aws.sagemaker.model.primitives.MonitoringScheduleName(value)
      )
    override val monitoringScheduleStatus
        : Option[zio.aws.sagemaker.model.ScheduleStatus] = scala
      .Option(impl.monitoringScheduleStatus())
      .map(value => zio.aws.sagemaker.model.ScheduleStatus.wrap(value))
    override val monitoringType
        : Option[zio.aws.sagemaker.model.MonitoringType] = scala
      .Option(impl.monitoringType())
      .map(value => zio.aws.sagemaker.model.MonitoringType.wrap(value))
    override val failureReason: Option[FailureReason] = scala
      .Option(impl.failureReason())
      .map(value => zio.aws.sagemaker.model.primitives.FailureReason(value))
    override val creationTime: Option[Timestamp] = scala
      .Option(impl.creationTime())
      .map(value => zio.aws.sagemaker.model.primitives.Timestamp(value))
    override val lastModifiedTime: Option[Timestamp] = scala
      .Option(impl.lastModifiedTime())
      .map(value => zio.aws.sagemaker.model.primitives.Timestamp(value))
    override val monitoringScheduleConfig
        : Option[zio.aws.sagemaker.model.MonitoringScheduleConfig.ReadOnly] =
      scala
        .Option(impl.monitoringScheduleConfig())
        .map(value =>
          zio.aws.sagemaker.model.MonitoringScheduleConfig.wrap(value)
        )
    override val endpointName: Option[EndpointName] = scala
      .Option(impl.endpointName())
      .map(value => zio.aws.sagemaker.model.primitives.EndpointName(value))
    override val lastMonitoringExecutionSummary
        : Option[zio.aws.sagemaker.model.MonitoringExecutionSummary.ReadOnly] =
      scala
        .Option(impl.lastMonitoringExecutionSummary())
        .map(value =>
          zio.aws.sagemaker.model.MonitoringExecutionSummary.wrap(value)
        )
    override val tags: Option[List[zio.aws.sagemaker.model.Tag.ReadOnly]] =
      scala
        .Option(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.sagemaker.model.Tag.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.MonitoringSchedule
  ): zio.aws.sagemaker.model.MonitoringSchedule.ReadOnly = new Wrapper(impl)
}
