package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.sagemaker.model.primitives.KmsKeyId
import scala.jdk.CollectionConverters.*
final case class MonitoringOutputConfig(
    monitoringOutputs: Iterable[zio.aws.sagemaker.model.MonitoringOutput],
    kmsKeyId: Option[KmsKeyId] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.MonitoringOutputConfig = {
    import MonitoringOutputConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.MonitoringOutputConfig
      .builder()
      .monitoringOutputs(monitoringOutputs.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(
        kmsKeyId.map(value => KmsKeyId.unwrap(value): java.lang.String)
      )(_.kmsKeyId)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.MonitoringOutputConfig.ReadOnly =
    zio.aws.sagemaker.model.MonitoringOutputConfig.wrap(buildAwsValue())
}
object MonitoringOutputConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.MonitoringOutputConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.MonitoringOutputConfig =
      zio.aws.sagemaker.model.MonitoringOutputConfig(
        monitoringOutputs.map { item =>
          item.asEditable
        },
        kmsKeyId.map(value => value)
      )
    def monitoringOutputs
        : List[zio.aws.sagemaker.model.MonitoringOutput.ReadOnly]
    def kmsKeyId: Option[KmsKeyId]
    def getMonitoringOutputs: ZIO[Any, Nothing, List[
      zio.aws.sagemaker.model.MonitoringOutput.ReadOnly
    ]] = ZIO.succeed(monitoringOutputs)
    def getKmsKeyId: ZIO[Any, AwsError, KmsKeyId] =
      AwsError.unwrapOptionField("kmsKeyId", kmsKeyId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.MonitoringOutputConfig
  ) extends zio.aws.sagemaker.model.MonitoringOutputConfig.ReadOnly {
    override val monitoringOutputs
        : List[zio.aws.sagemaker.model.MonitoringOutput.ReadOnly] = impl
      .monitoringOutputs()
      .asScala
      .map { item =>
        zio.aws.sagemaker.model.MonitoringOutput.wrap(item)
      }
      .toList
    override val kmsKeyId: Option[KmsKeyId] = scala
      .Option(impl.kmsKeyId())
      .map(value => zio.aws.sagemaker.model.primitives.KmsKeyId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.MonitoringOutputConfig
  ): zio.aws.sagemaker.model.MonitoringOutputConfig.ReadOnly = new Wrapper(impl)
}
