package zio.aws.sagemaker.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.sagemaker.model.primitives.{
  MaxResults,
  NextToken,
  PipelineExecutionArn
}
import scala.jdk.CollectionConverters.*
final case class ListPipelineExecutionStepsRequest(
    pipelineExecutionArn: Option[PipelineExecutionArn] = None,
    nextToken: Option[NextToken] = None,
    maxResults: Option[MaxResults] = None,
    sortOrder: Option[zio.aws.sagemaker.model.SortOrder] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.ListPipelineExecutionStepsRequest = {
    import ListPipelineExecutionStepsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.ListPipelineExecutionStepsRequest
      .builder()
      .optionallyWith(
        pipelineExecutionArn.map(value =>
          PipelineExecutionArn.unwrap(value): java.lang.String
        )
      )(_.pipelineExecutionArn)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(sortOrder.map(value => value.unwrap))(_.sortOrder)
      .build()
  }
  def asReadOnly
      : zio.aws.sagemaker.model.ListPipelineExecutionStepsRequest.ReadOnly =
    zio.aws.sagemaker.model.ListPipelineExecutionStepsRequest
      .wrap(buildAwsValue())
}
object ListPipelineExecutionStepsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.ListPipelineExecutionStepsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.ListPipelineExecutionStepsRequest =
      zio.aws.sagemaker.model.ListPipelineExecutionStepsRequest(
        pipelineExecutionArn.map(value => value),
        nextToken.map(value => value),
        maxResults.map(value => value),
        sortOrder.map(value => value)
      )
    def pipelineExecutionArn: Option[PipelineExecutionArn]
    def nextToken: Option[NextToken]
    def maxResults: Option[MaxResults]
    def sortOrder: Option[zio.aws.sagemaker.model.SortOrder]
    def getPipelineExecutionArn: ZIO[Any, AwsError, PipelineExecutionArn] =
      AwsError.unwrapOptionField("pipelineExecutionArn", pipelineExecutionArn)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getSortOrder: ZIO[Any, AwsError, zio.aws.sagemaker.model.SortOrder] =
      AwsError.unwrapOptionField("sortOrder", sortOrder)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.ListPipelineExecutionStepsRequest
  ) extends zio.aws.sagemaker.model.ListPipelineExecutionStepsRequest.ReadOnly {
    override val pipelineExecutionArn: Option[PipelineExecutionArn] = scala
      .Option(impl.pipelineExecutionArn())
      .map(value =>
        zio.aws.sagemaker.model.primitives.PipelineExecutionArn(value)
      )
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.sagemaker.model.primitives.NextToken(value))
    override val maxResults: Option[MaxResults] = scala
      .Option(impl.maxResults())
      .map(value => zio.aws.sagemaker.model.primitives.MaxResults(value))
    override val sortOrder: Option[zio.aws.sagemaker.model.SortOrder] = scala
      .Option(impl.sortOrder())
      .map(value => zio.aws.sagemaker.model.SortOrder.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.ListPipelineExecutionStepsRequest
  ): zio.aws.sagemaker.model.ListPipelineExecutionStepsRequest.ReadOnly =
    new Wrapper(impl)
}
