package zio.aws.sagemaker.model
import zio.aws.sagemaker.model.primitives.{
  CreationTime,
  NextToken,
  NameContains,
  ArnOrName,
  MaxResults
}
import java.time.Instant
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class ListModelPackagesRequest(
    creationTimeAfter: Option[CreationTime] = None,
    creationTimeBefore: Option[CreationTime] = None,
    maxResults: Option[MaxResults] = None,
    nameContains: Option[NameContains] = None,
    modelApprovalStatus: Option[zio.aws.sagemaker.model.ModelApprovalStatus] =
      None,
    modelPackageGroupName: Option[ArnOrName] = None,
    modelPackageType: Option[zio.aws.sagemaker.model.ModelPackageType] = None,
    nextToken: Option[NextToken] = None,
    sortBy: Option[zio.aws.sagemaker.model.ModelPackageSortBy] = None,
    sortOrder: Option[zio.aws.sagemaker.model.SortOrder] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.ListModelPackagesRequest = {
    import ListModelPackagesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.ListModelPackagesRequest
      .builder()
      .optionallyWith(
        creationTimeAfter.map(value => CreationTime.unwrap(value): Instant)
      )(_.creationTimeAfter)
      .optionallyWith(
        creationTimeBefore.map(value => CreationTime.unwrap(value): Instant)
      )(_.creationTimeBefore)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nameContains.map(value => NameContains.unwrap(value): java.lang.String)
      )(_.nameContains)
      .optionallyWith(modelApprovalStatus.map(value => value.unwrap))(
        _.modelApprovalStatus
      )
      .optionallyWith(
        modelPackageGroupName.map(value =>
          ArnOrName.unwrap(value): java.lang.String
        )
      )(_.modelPackageGroupName)
      .optionallyWith(modelPackageType.map(value => value.unwrap))(
        _.modelPackageType
      )
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(sortBy.map(value => value.unwrap))(_.sortBy)
      .optionallyWith(sortOrder.map(value => value.unwrap))(_.sortOrder)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.ListModelPackagesRequest.ReadOnly =
    zio.aws.sagemaker.model.ListModelPackagesRequest.wrap(buildAwsValue())
}
object ListModelPackagesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.ListModelPackagesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.ListModelPackagesRequest =
      zio.aws.sagemaker.model.ListModelPackagesRequest(
        creationTimeAfter.map(value => value),
        creationTimeBefore.map(value => value),
        maxResults.map(value => value),
        nameContains.map(value => value),
        modelApprovalStatus.map(value => value),
        modelPackageGroupName.map(value => value),
        modelPackageType.map(value => value),
        nextToken.map(value => value),
        sortBy.map(value => value),
        sortOrder.map(value => value)
      )
    def creationTimeAfter: Option[CreationTime]
    def creationTimeBefore: Option[CreationTime]
    def maxResults: Option[MaxResults]
    def nameContains: Option[NameContains]
    def modelApprovalStatus: Option[zio.aws.sagemaker.model.ModelApprovalStatus]
    def modelPackageGroupName: Option[ArnOrName]
    def modelPackageType: Option[zio.aws.sagemaker.model.ModelPackageType]
    def nextToken: Option[NextToken]
    def sortBy: Option[zio.aws.sagemaker.model.ModelPackageSortBy]
    def sortOrder: Option[zio.aws.sagemaker.model.SortOrder]
    def getCreationTimeAfter: ZIO[Any, AwsError, CreationTime] =
      AwsError.unwrapOptionField("creationTimeAfter", creationTimeAfter)
    def getCreationTimeBefore: ZIO[Any, AwsError, CreationTime] =
      AwsError.unwrapOptionField("creationTimeBefore", creationTimeBefore)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNameContains: ZIO[Any, AwsError, NameContains] =
      AwsError.unwrapOptionField("nameContains", nameContains)
    def getModelApprovalStatus
        : ZIO[Any, AwsError, zio.aws.sagemaker.model.ModelApprovalStatus] =
      AwsError.unwrapOptionField("modelApprovalStatus", modelApprovalStatus)
    def getModelPackageGroupName: ZIO[Any, AwsError, ArnOrName] =
      AwsError.unwrapOptionField("modelPackageGroupName", modelPackageGroupName)
    def getModelPackageType
        : ZIO[Any, AwsError, zio.aws.sagemaker.model.ModelPackageType] =
      AwsError.unwrapOptionField("modelPackageType", modelPackageType)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getSortBy
        : ZIO[Any, AwsError, zio.aws.sagemaker.model.ModelPackageSortBy] =
      AwsError.unwrapOptionField("sortBy", sortBy)
    def getSortOrder: ZIO[Any, AwsError, zio.aws.sagemaker.model.SortOrder] =
      AwsError.unwrapOptionField("sortOrder", sortOrder)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.ListModelPackagesRequest
  ) extends zio.aws.sagemaker.model.ListModelPackagesRequest.ReadOnly {
    override val creationTimeAfter: Option[CreationTime] = scala
      .Option(impl.creationTimeAfter())
      .map(value => zio.aws.sagemaker.model.primitives.CreationTime(value))
    override val creationTimeBefore: Option[CreationTime] = scala
      .Option(impl.creationTimeBefore())
      .map(value => zio.aws.sagemaker.model.primitives.CreationTime(value))
    override val maxResults: Option[MaxResults] = scala
      .Option(impl.maxResults())
      .map(value => zio.aws.sagemaker.model.primitives.MaxResults(value))
    override val nameContains: Option[NameContains] = scala
      .Option(impl.nameContains())
      .map(value => zio.aws.sagemaker.model.primitives.NameContains(value))
    override val modelApprovalStatus
        : Option[zio.aws.sagemaker.model.ModelApprovalStatus] = scala
      .Option(impl.modelApprovalStatus())
      .map(value => zio.aws.sagemaker.model.ModelApprovalStatus.wrap(value))
    override val modelPackageGroupName: Option[ArnOrName] = scala
      .Option(impl.modelPackageGroupName())
      .map(value => zio.aws.sagemaker.model.primitives.ArnOrName(value))
    override val modelPackageType
        : Option[zio.aws.sagemaker.model.ModelPackageType] = scala
      .Option(impl.modelPackageType())
      .map(value => zio.aws.sagemaker.model.ModelPackageType.wrap(value))
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.sagemaker.model.primitives.NextToken(value))
    override val sortBy: Option[zio.aws.sagemaker.model.ModelPackageSortBy] =
      scala
        .Option(impl.sortBy())
        .map(value => zio.aws.sagemaker.model.ModelPackageSortBy.wrap(value))
    override val sortOrder: Option[zio.aws.sagemaker.model.SortOrder] = scala
      .Option(impl.sortOrder())
      .map(value => zio.aws.sagemaker.model.SortOrder.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.ListModelPackagesRequest
  ): zio.aws.sagemaker.model.ListModelPackagesRequest.ReadOnly = new Wrapper(
    impl
  )
}
