package zio.aws.sagemaker.model
import zio.aws.sagemaker.model.primitives.{
  CreationTime,
  NextToken,
  NameContains,
  LastModifiedTime,
  MaxResults
}
import java.time.Instant
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class ListCompilationJobsRequest(
    nextToken: Option[NextToken] = None,
    maxResults: Option[MaxResults] = None,
    creationTimeAfter: Option[CreationTime] = None,
    creationTimeBefore: Option[CreationTime] = None,
    lastModifiedTimeAfter: Option[LastModifiedTime] = None,
    lastModifiedTimeBefore: Option[LastModifiedTime] = None,
    nameContains: Option[NameContains] = None,
    statusEquals: Option[zio.aws.sagemaker.model.CompilationJobStatus] = None,
    sortBy: Option[zio.aws.sagemaker.model.ListCompilationJobsSortBy] = None,
    sortOrder: Option[zio.aws.sagemaker.model.SortOrder] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.ListCompilationJobsRequest = {
    import ListCompilationJobsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.ListCompilationJobsRequest
      .builder()
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        creationTimeAfter.map(value => CreationTime.unwrap(value): Instant)
      )(_.creationTimeAfter)
      .optionallyWith(
        creationTimeBefore.map(value => CreationTime.unwrap(value): Instant)
      )(_.creationTimeBefore)
      .optionallyWith(
        lastModifiedTimeAfter.map(value =>
          LastModifiedTime.unwrap(value): Instant
        )
      )(_.lastModifiedTimeAfter)
      .optionallyWith(
        lastModifiedTimeBefore.map(value =>
          LastModifiedTime.unwrap(value): Instant
        )
      )(_.lastModifiedTimeBefore)
      .optionallyWith(
        nameContains.map(value => NameContains.unwrap(value): java.lang.String)
      )(_.nameContains)
      .optionallyWith(statusEquals.map(value => value.unwrap))(_.statusEquals)
      .optionallyWith(sortBy.map(value => value.unwrap))(_.sortBy)
      .optionallyWith(sortOrder.map(value => value.unwrap))(_.sortOrder)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.ListCompilationJobsRequest.ReadOnly =
    zio.aws.sagemaker.model.ListCompilationJobsRequest.wrap(buildAwsValue())
}
object ListCompilationJobsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.ListCompilationJobsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.ListCompilationJobsRequest =
      zio.aws.sagemaker.model.ListCompilationJobsRequest(
        nextToken.map(value => value),
        maxResults.map(value => value),
        creationTimeAfter.map(value => value),
        creationTimeBefore.map(value => value),
        lastModifiedTimeAfter.map(value => value),
        lastModifiedTimeBefore.map(value => value),
        nameContains.map(value => value),
        statusEquals.map(value => value),
        sortBy.map(value => value),
        sortOrder.map(value => value)
      )
    def nextToken: Option[NextToken]
    def maxResults: Option[MaxResults]
    def creationTimeAfter: Option[CreationTime]
    def creationTimeBefore: Option[CreationTime]
    def lastModifiedTimeAfter: Option[LastModifiedTime]
    def lastModifiedTimeBefore: Option[LastModifiedTime]
    def nameContains: Option[NameContains]
    def statusEquals: Option[zio.aws.sagemaker.model.CompilationJobStatus]
    def sortBy: Option[zio.aws.sagemaker.model.ListCompilationJobsSortBy]
    def sortOrder: Option[zio.aws.sagemaker.model.SortOrder]
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getCreationTimeAfter: ZIO[Any, AwsError, CreationTime] =
      AwsError.unwrapOptionField("creationTimeAfter", creationTimeAfter)
    def getCreationTimeBefore: ZIO[Any, AwsError, CreationTime] =
      AwsError.unwrapOptionField("creationTimeBefore", creationTimeBefore)
    def getLastModifiedTimeAfter: ZIO[Any, AwsError, LastModifiedTime] =
      AwsError.unwrapOptionField("lastModifiedTimeAfter", lastModifiedTimeAfter)
    def getLastModifiedTimeBefore: ZIO[Any, AwsError, LastModifiedTime] =
      AwsError.unwrapOptionField(
        "lastModifiedTimeBefore",
        lastModifiedTimeBefore
      )
    def getNameContains: ZIO[Any, AwsError, NameContains] =
      AwsError.unwrapOptionField("nameContains", nameContains)
    def getStatusEquals
        : ZIO[Any, AwsError, zio.aws.sagemaker.model.CompilationJobStatus] =
      AwsError.unwrapOptionField("statusEquals", statusEquals)
    def getSortBy: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.ListCompilationJobsSortBy
    ] = AwsError.unwrapOptionField("sortBy", sortBy)
    def getSortOrder: ZIO[Any, AwsError, zio.aws.sagemaker.model.SortOrder] =
      AwsError.unwrapOptionField("sortOrder", sortOrder)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.ListCompilationJobsRequest
  ) extends zio.aws.sagemaker.model.ListCompilationJobsRequest.ReadOnly {
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.sagemaker.model.primitives.NextToken(value))
    override val maxResults: Option[MaxResults] = scala
      .Option(impl.maxResults())
      .map(value => zio.aws.sagemaker.model.primitives.MaxResults(value))
    override val creationTimeAfter: Option[CreationTime] = scala
      .Option(impl.creationTimeAfter())
      .map(value => zio.aws.sagemaker.model.primitives.CreationTime(value))
    override val creationTimeBefore: Option[CreationTime] = scala
      .Option(impl.creationTimeBefore())
      .map(value => zio.aws.sagemaker.model.primitives.CreationTime(value))
    override val lastModifiedTimeAfter: Option[LastModifiedTime] = scala
      .Option(impl.lastModifiedTimeAfter())
      .map(value => zio.aws.sagemaker.model.primitives.LastModifiedTime(value))
    override val lastModifiedTimeBefore: Option[LastModifiedTime] = scala
      .Option(impl.lastModifiedTimeBefore())
      .map(value => zio.aws.sagemaker.model.primitives.LastModifiedTime(value))
    override val nameContains: Option[NameContains] = scala
      .Option(impl.nameContains())
      .map(value => zio.aws.sagemaker.model.primitives.NameContains(value))
    override val statusEquals
        : Option[zio.aws.sagemaker.model.CompilationJobStatus] = scala
      .Option(impl.statusEquals())
      .map(value => zio.aws.sagemaker.model.CompilationJobStatus.wrap(value))
    override val sortBy
        : Option[zio.aws.sagemaker.model.ListCompilationJobsSortBy] = scala
      .Option(impl.sortBy())
      .map(value =>
        zio.aws.sagemaker.model.ListCompilationJobsSortBy.wrap(value)
      )
    override val sortOrder: Option[zio.aws.sagemaker.model.SortOrder] = scala
      .Option(impl.sortOrder())
      .map(value => zio.aws.sagemaker.model.SortOrder.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.ListCompilationJobsRequest
  ): zio.aws.sagemaker.model.ListCompilationJobsRequest.ReadOnly = new Wrapper(
    impl
  )
}
