package zio.aws.sagemaker.model
import zio.aws.sagemaker.model.primitives.{
  NextToken,
  AutoMLMaxResults,
  AutoMLNameContains,
  Timestamp
}
import java.time.Instant
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class ListAutoMlJobsRequest(
    creationTimeAfter: Option[Timestamp] = None,
    creationTimeBefore: Option[Timestamp] = None,
    lastModifiedTimeAfter: Option[Timestamp] = None,
    lastModifiedTimeBefore: Option[Timestamp] = None,
    nameContains: Option[AutoMLNameContains] = None,
    statusEquals: Option[zio.aws.sagemaker.model.AutoMLJobStatus] = None,
    sortOrder: Option[zio.aws.sagemaker.model.AutoMLSortOrder] = None,
    sortBy: Option[zio.aws.sagemaker.model.AutoMLSortBy] = None,
    maxResults: Option[AutoMLMaxResults] = None,
    nextToken: Option[NextToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.ListAutoMlJobsRequest = {
    import ListAutoMlJobsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.ListAutoMlJobsRequest
      .builder()
      .optionallyWith(
        creationTimeAfter.map(value => Timestamp.unwrap(value): Instant)
      )(_.creationTimeAfter)
      .optionallyWith(
        creationTimeBefore.map(value => Timestamp.unwrap(value): Instant)
      )(_.creationTimeBefore)
      .optionallyWith(
        lastModifiedTimeAfter.map(value => Timestamp.unwrap(value): Instant)
      )(_.lastModifiedTimeAfter)
      .optionallyWith(
        lastModifiedTimeBefore.map(value => Timestamp.unwrap(value): Instant)
      )(_.lastModifiedTimeBefore)
      .optionallyWith(
        nameContains.map(value =>
          AutoMLNameContains.unwrap(value): java.lang.String
        )
      )(_.nameContains)
      .optionallyWith(statusEquals.map(value => value.unwrap))(_.statusEquals)
      .optionallyWith(sortOrder.map(value => value.unwrap))(_.sortOrder)
      .optionallyWith(sortBy.map(value => value.unwrap))(_.sortBy)
      .optionallyWith(
        maxResults.map(value => AutoMLMaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.ListAutoMlJobsRequest.ReadOnly =
    zio.aws.sagemaker.model.ListAutoMlJobsRequest.wrap(buildAwsValue())
}
object ListAutoMlJobsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.ListAutoMlJobsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.ListAutoMlJobsRequest =
      zio.aws.sagemaker.model.ListAutoMlJobsRequest(
        creationTimeAfter.map(value => value),
        creationTimeBefore.map(value => value),
        lastModifiedTimeAfter.map(value => value),
        lastModifiedTimeBefore.map(value => value),
        nameContains.map(value => value),
        statusEquals.map(value => value),
        sortOrder.map(value => value),
        sortBy.map(value => value),
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def creationTimeAfter: Option[Timestamp]
    def creationTimeBefore: Option[Timestamp]
    def lastModifiedTimeAfter: Option[Timestamp]
    def lastModifiedTimeBefore: Option[Timestamp]
    def nameContains: Option[AutoMLNameContains]
    def statusEquals: Option[zio.aws.sagemaker.model.AutoMLJobStatus]
    def sortOrder: Option[zio.aws.sagemaker.model.AutoMLSortOrder]
    def sortBy: Option[zio.aws.sagemaker.model.AutoMLSortBy]
    def maxResults: Option[AutoMLMaxResults]
    def nextToken: Option[NextToken]
    def getCreationTimeAfter: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("creationTimeAfter", creationTimeAfter)
    def getCreationTimeBefore: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("creationTimeBefore", creationTimeBefore)
    def getLastModifiedTimeAfter: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("lastModifiedTimeAfter", lastModifiedTimeAfter)
    def getLastModifiedTimeBefore: ZIO[Any, AwsError, Timestamp] = AwsError
      .unwrapOptionField("lastModifiedTimeBefore", lastModifiedTimeBefore)
    def getNameContains: ZIO[Any, AwsError, AutoMLNameContains] =
      AwsError.unwrapOptionField("nameContains", nameContains)
    def getStatusEquals
        : ZIO[Any, AwsError, zio.aws.sagemaker.model.AutoMLJobStatus] =
      AwsError.unwrapOptionField("statusEquals", statusEquals)
    def getSortOrder
        : ZIO[Any, AwsError, zio.aws.sagemaker.model.AutoMLSortOrder] =
      AwsError.unwrapOptionField("sortOrder", sortOrder)
    def getSortBy: ZIO[Any, AwsError, zio.aws.sagemaker.model.AutoMLSortBy] =
      AwsError.unwrapOptionField("sortBy", sortBy)
    def getMaxResults: ZIO[Any, AwsError, AutoMLMaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.ListAutoMlJobsRequest
  ) extends zio.aws.sagemaker.model.ListAutoMlJobsRequest.ReadOnly {
    override val creationTimeAfter: Option[Timestamp] = scala
      .Option(impl.creationTimeAfter())
      .map(value => zio.aws.sagemaker.model.primitives.Timestamp(value))
    override val creationTimeBefore: Option[Timestamp] = scala
      .Option(impl.creationTimeBefore())
      .map(value => zio.aws.sagemaker.model.primitives.Timestamp(value))
    override val lastModifiedTimeAfter: Option[Timestamp] = scala
      .Option(impl.lastModifiedTimeAfter())
      .map(value => zio.aws.sagemaker.model.primitives.Timestamp(value))
    override val lastModifiedTimeBefore: Option[Timestamp] = scala
      .Option(impl.lastModifiedTimeBefore())
      .map(value => zio.aws.sagemaker.model.primitives.Timestamp(value))
    override val nameContains: Option[AutoMLNameContains] = scala
      .Option(impl.nameContains())
      .map(value =>
        zio.aws.sagemaker.model.primitives.AutoMLNameContains(value)
      )
    override val statusEquals: Option[zio.aws.sagemaker.model.AutoMLJobStatus] =
      scala
        .Option(impl.statusEquals())
        .map(value => zio.aws.sagemaker.model.AutoMLJobStatus.wrap(value))
    override val sortOrder: Option[zio.aws.sagemaker.model.AutoMLSortOrder] =
      scala
        .Option(impl.sortOrder())
        .map(value => zio.aws.sagemaker.model.AutoMLSortOrder.wrap(value))
    override val sortBy: Option[zio.aws.sagemaker.model.AutoMLSortBy] = scala
      .Option(impl.sortBy())
      .map(value => zio.aws.sagemaker.model.AutoMLSortBy.wrap(value))
    override val maxResults: Option[AutoMLMaxResults] = scala
      .Option(impl.maxResults())
      .map(value => zio.aws.sagemaker.model.primitives.AutoMLMaxResults(value))
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.sagemaker.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.ListAutoMlJobsRequest
  ): zio.aws.sagemaker.model.ListAutoMlJobsRequest.ReadOnly = new Wrapper(impl)
}
