package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.sagemaker.model.primitives.NextToken
import scala.jdk.CollectionConverters.*
final case class ListArtifactsResponse(
    artifactSummaries: Option[
      Iterable[zio.aws.sagemaker.model.ArtifactSummary]
    ] = None,
    nextToken: Option[NextToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.ListArtifactsResponse = {
    import ListArtifactsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.ListArtifactsResponse
      .builder()
      .optionallyWith(
        artifactSummaries.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.artifactSummaries)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.ListArtifactsResponse.ReadOnly =
    zio.aws.sagemaker.model.ListArtifactsResponse.wrap(buildAwsValue())
}
object ListArtifactsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.ListArtifactsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.ListArtifactsResponse =
      zio.aws.sagemaker.model.ListArtifactsResponse(
        artifactSummaries.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def artifactSummaries
        : Option[List[zio.aws.sagemaker.model.ArtifactSummary.ReadOnly]]
    def nextToken: Option[NextToken]
    def getArtifactSummaries: ZIO[Any, AwsError, List[
      zio.aws.sagemaker.model.ArtifactSummary.ReadOnly
    ]] = AwsError.unwrapOptionField("artifactSummaries", artifactSummaries)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.ListArtifactsResponse
  ) extends zio.aws.sagemaker.model.ListArtifactsResponse.ReadOnly {
    override val artifactSummaries
        : Option[List[zio.aws.sagemaker.model.ArtifactSummary.ReadOnly]] = scala
      .Option(impl.artifactSummaries())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.sagemaker.model.ArtifactSummary.wrap(item)
        }.toList
      )
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.sagemaker.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.ListArtifactsResponse
  ): zio.aws.sagemaker.model.ListArtifactsResponse.ReadOnly = new Wrapper(impl)
}
