package zio.aws.sagemaker.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.sagemaker.model.primitives.{
  MaxPercentageOfInputDatasetLabeled,
  MaxHumanLabeledObjectCount
}
import scala.jdk.CollectionConverters.*
final case class LabelingJobStoppingConditions(
    maxHumanLabeledObjectCount: Option[MaxHumanLabeledObjectCount] = None,
    maxPercentageOfInputDatasetLabeled: Option[
      MaxPercentageOfInputDatasetLabeled
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.LabelingJobStoppingConditions = {
    import LabelingJobStoppingConditions.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.LabelingJobStoppingConditions
      .builder()
      .optionallyWith(
        maxHumanLabeledObjectCount.map(value =>
          MaxHumanLabeledObjectCount.unwrap(value): Integer
        )
      )(_.maxHumanLabeledObjectCount)
      .optionallyWith(
        maxPercentageOfInputDatasetLabeled.map(value =>
          MaxPercentageOfInputDatasetLabeled.unwrap(value): Integer
        )
      )(_.maxPercentageOfInputDatasetLabeled)
      .build()
  }
  def asReadOnly
      : zio.aws.sagemaker.model.LabelingJobStoppingConditions.ReadOnly =
    zio.aws.sagemaker.model.LabelingJobStoppingConditions.wrap(buildAwsValue())
}
object LabelingJobStoppingConditions {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.LabelingJobStoppingConditions
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.LabelingJobStoppingConditions =
      zio.aws.sagemaker.model.LabelingJobStoppingConditions(
        maxHumanLabeledObjectCount.map(value => value),
        maxPercentageOfInputDatasetLabeled.map(value => value)
      )
    def maxHumanLabeledObjectCount: Option[MaxHumanLabeledObjectCount]
    def maxPercentageOfInputDatasetLabeled
        : Option[MaxPercentageOfInputDatasetLabeled]
    def getMaxHumanLabeledObjectCount
        : ZIO[Any, AwsError, MaxHumanLabeledObjectCount] =
      AwsError.unwrapOptionField(
        "maxHumanLabeledObjectCount",
        maxHumanLabeledObjectCount
      )
    def getMaxPercentageOfInputDatasetLabeled
        : ZIO[Any, AwsError, MaxPercentageOfInputDatasetLabeled] =
      AwsError.unwrapOptionField(
        "maxPercentageOfInputDatasetLabeled",
        maxPercentageOfInputDatasetLabeled
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.LabelingJobStoppingConditions
  ) extends zio.aws.sagemaker.model.LabelingJobStoppingConditions.ReadOnly {
    override val maxHumanLabeledObjectCount
        : Option[MaxHumanLabeledObjectCount] = scala
      .Option(impl.maxHumanLabeledObjectCount())
      .map(value =>
        zio.aws.sagemaker.model.primitives.MaxHumanLabeledObjectCount(value)
      )
    override val maxPercentageOfInputDatasetLabeled
        : Option[MaxPercentageOfInputDatasetLabeled] = scala
      .Option(impl.maxPercentageOfInputDatasetLabeled())
      .map(value =>
        zio.aws.sagemaker.model.primitives
          .MaxPercentageOfInputDatasetLabeled(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.LabelingJobStoppingConditions
  ): zio.aws.sagemaker.model.LabelingJobStoppingConditions.ReadOnly =
    new Wrapper(impl)
}
