package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.sagemaker.model.primitives.{
  HyperParameterValue,
  EntityDescription,
  ParameterName
}
import scala.jdk.CollectionConverters.*
final case class HyperParameterSpecification(
    name: ParameterName,
    description: Option[EntityDescription] = None,
    `type`: zio.aws.sagemaker.model.ParameterType,
    range: Option[zio.aws.sagemaker.model.ParameterRange] = None,
    isTunable: Option[Boolean] = None,
    isRequired: Option[Boolean] = None,
    defaultValue: Option[HyperParameterValue] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.HyperParameterSpecification = {
    import HyperParameterSpecification.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.HyperParameterSpecification
      .builder()
      .name(ParameterName.unwrap(name): java.lang.String)
      .optionallyWith(
        description.map(value =>
          EntityDescription.unwrap(value): java.lang.String
        )
      )(_.description)
      .`type`(`type`.unwrap)
      .optionallyWith(range.map(value => value.buildAwsValue()))(_.range)
      .optionallyWith(isTunable.map(value => value: java.lang.Boolean))(
        _.isTunable
      )
      .optionallyWith(isRequired.map(value => value: java.lang.Boolean))(
        _.isRequired
      )
      .optionallyWith(
        defaultValue.map(value =>
          HyperParameterValue.unwrap(value): java.lang.String
        )
      )(_.defaultValue)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.HyperParameterSpecification.ReadOnly =
    zio.aws.sagemaker.model.HyperParameterSpecification.wrap(buildAwsValue())
}
object HyperParameterSpecification {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.HyperParameterSpecification
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.HyperParameterSpecification =
      zio.aws.sagemaker.model.HyperParameterSpecification(
        name,
        description.map(value => value),
        `type`,
        range.map(value => value.asEditable),
        isTunable.map(value => value),
        isRequired.map(value => value),
        defaultValue.map(value => value)
      )
    def name: ParameterName
    def description: Option[EntityDescription]
    def `type`: zio.aws.sagemaker.model.ParameterType
    def range: Option[zio.aws.sagemaker.model.ParameterRange.ReadOnly]
    def isTunable: Option[Boolean]
    def isRequired: Option[Boolean]
    def defaultValue: Option[HyperParameterValue]
    def getName: ZIO[Any, Nothing, ParameterName] = ZIO.succeed(name)
    def getDescription: ZIO[Any, AwsError, EntityDescription] =
      AwsError.unwrapOptionField("description", description)
    def getType: ZIO[Any, Nothing, zio.aws.sagemaker.model.ParameterType] =
      ZIO.succeed(`type`)
    def getRange
        : ZIO[Any, AwsError, zio.aws.sagemaker.model.ParameterRange.ReadOnly] =
      AwsError.unwrapOptionField("range", range)
    def getIsTunable: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("isTunable", isTunable)
    def getIsRequired: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("isRequired", isRequired)
    def getDefaultValue: ZIO[Any, AwsError, HyperParameterValue] =
      AwsError.unwrapOptionField("defaultValue", defaultValue)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.HyperParameterSpecification
  ) extends zio.aws.sagemaker.model.HyperParameterSpecification.ReadOnly {
    override val name: ParameterName =
      zio.aws.sagemaker.model.primitives.ParameterName(impl.name())
    override val description: Option[EntityDescription] = scala
      .Option(impl.description())
      .map(value => zio.aws.sagemaker.model.primitives.EntityDescription(value))
    override val `type`: zio.aws.sagemaker.model.ParameterType =
      zio.aws.sagemaker.model.ParameterType.wrap(impl.`type`())
    override val range
        : Option[zio.aws.sagemaker.model.ParameterRange.ReadOnly] = scala
      .Option(impl.range())
      .map(value => zio.aws.sagemaker.model.ParameterRange.wrap(value))
    override val isTunable: Option[Boolean] =
      scala.Option(impl.isTunable()).map(value => value: Boolean)
    override val isRequired: Option[Boolean] =
      scala.Option(impl.isRequired()).map(value => value: Boolean)
    override val defaultValue: Option[HyperParameterValue] = scala
      .Option(impl.defaultValue())
      .map(value =>
        zio.aws.sagemaker.model.primitives.HyperParameterValue(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.HyperParameterSpecification
  ): zio.aws.sagemaker.model.HyperParameterSpecification.ReadOnly = new Wrapper(
    impl
  )
}
