package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import zio.aws.sagemaker.model.primitives.{
  Timestamp,
  ExperimentEntityName,
  ExperimentArn
}
import scala.jdk.CollectionConverters.*
final case class ExperimentSummary(
    experimentArn: Option[ExperimentArn] = None,
    experimentName: Option[ExperimentEntityName] = None,
    displayName: Option[ExperimentEntityName] = None,
    experimentSource: Option[zio.aws.sagemaker.model.ExperimentSource] = None,
    creationTime: Option[Timestamp] = None,
    lastModifiedTime: Option[Timestamp] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.ExperimentSummary = {
    import ExperimentSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.ExperimentSummary
      .builder()
      .optionallyWith(
        experimentArn.map(value =>
          ExperimentArn.unwrap(value): java.lang.String
        )
      )(_.experimentArn)
      .optionallyWith(
        experimentName.map(value =>
          ExperimentEntityName.unwrap(value): java.lang.String
        )
      )(_.experimentName)
      .optionallyWith(
        displayName.map(value =>
          ExperimentEntityName.unwrap(value): java.lang.String
        )
      )(_.displayName)
      .optionallyWith(experimentSource.map(value => value.buildAwsValue()))(
        _.experimentSource
      )
      .optionallyWith(
        creationTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.creationTime)
      .optionallyWith(
        lastModifiedTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.lastModifiedTime)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.ExperimentSummary.ReadOnly =
    zio.aws.sagemaker.model.ExperimentSummary.wrap(buildAwsValue())
}
object ExperimentSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.ExperimentSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.ExperimentSummary =
      zio.aws.sagemaker.model.ExperimentSummary(
        experimentArn.map(value => value),
        experimentName.map(value => value),
        displayName.map(value => value),
        experimentSource.map(value => value.asEditable),
        creationTime.map(value => value),
        lastModifiedTime.map(value => value)
      )
    def experimentArn: Option[ExperimentArn]
    def experimentName: Option[ExperimentEntityName]
    def displayName: Option[ExperimentEntityName]
    def experimentSource
        : Option[zio.aws.sagemaker.model.ExperimentSource.ReadOnly]
    def creationTime: Option[Timestamp]
    def lastModifiedTime: Option[Timestamp]
    def getExperimentArn: ZIO[Any, AwsError, ExperimentArn] =
      AwsError.unwrapOptionField("experimentArn", experimentArn)
    def getExperimentName: ZIO[Any, AwsError, ExperimentEntityName] =
      AwsError.unwrapOptionField("experimentName", experimentName)
    def getDisplayName: ZIO[Any, AwsError, ExperimentEntityName] =
      AwsError.unwrapOptionField("displayName", displayName)
    def getExperimentSource: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.ExperimentSource.ReadOnly
    ] = AwsError.unwrapOptionField("experimentSource", experimentSource)
    def getCreationTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("creationTime", creationTime)
    def getLastModifiedTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("lastModifiedTime", lastModifiedTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.ExperimentSummary
  ) extends zio.aws.sagemaker.model.ExperimentSummary.ReadOnly {
    override val experimentArn: Option[ExperimentArn] = scala
      .Option(impl.experimentArn())
      .map(value => zio.aws.sagemaker.model.primitives.ExperimentArn(value))
    override val experimentName: Option[ExperimentEntityName] = scala
      .Option(impl.experimentName())
      .map(value =>
        zio.aws.sagemaker.model.primitives.ExperimentEntityName(value)
      )
    override val displayName: Option[ExperimentEntityName] = scala
      .Option(impl.displayName())
      .map(value =>
        zio.aws.sagemaker.model.primitives.ExperimentEntityName(value)
      )
    override val experimentSource
        : Option[zio.aws.sagemaker.model.ExperimentSource.ReadOnly] = scala
      .Option(impl.experimentSource())
      .map(value => zio.aws.sagemaker.model.ExperimentSource.wrap(value))
    override val creationTime: Option[Timestamp] = scala
      .Option(impl.creationTime())
      .map(value => zio.aws.sagemaker.model.primitives.Timestamp(value))
    override val lastModifiedTime: Option[Timestamp] = scala
      .Option(impl.lastModifiedTime())
      .map(value => zio.aws.sagemaker.model.primitives.Timestamp(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.ExperimentSummary
  ): zio.aws.sagemaker.model.ExperimentSummary.ReadOnly = new Wrapper(impl)
}
